<?php


namespace Tangibledesign\Framework\Models;


use Tangibledesign\Framework\Models\Post\Post;
use WP_Error;

/**
 * Class Attachment
 * @package Tangibledesign\Framework\Models
 */
class Attachment extends Post
{
    /**
     * @return string
     */
    public function getUrl(): string
    {
        $url = wp_get_attachment_url($this->getId());
        if ($url instanceof WP_Error) {
            return '';
        }

        return $url;
    }

    /**
     * @return string
     */
    public function getFileName(): string
    {
        return basename($this->getFile());
    }

    /**
     * @return string
     */
    public function getFile(): string
    {
        return get_attached_file($this->getId());
    }

    /**
     * @return false|string
     */
    public function getType()
    {
        $url = $this->getUrl();
        if (!$url) {
            return false;
        }

        $type = wp_check_filetype($this->getUrl());

        return $type['ext'] ?? false;
    }

    /**
     * @return string
     */
    public function getIconUrl(): string
    {
        $type = $this->getType();

        if (!$type) {
            return get_template_directory_uri() . '/assets/img/other_file_type.svg';
        }

        if ($type === 'pdf') {
            return get_template_directory_uri() . '/assets/img/pdf.svg';
        }

        if ($type === 'png') {
            return get_template_directory_uri() . '/assets/img/png.svg';
        }

        if ($type === 'jpg' || $type === 'jpeg') {
            return get_template_directory_uri() . '/assets/img/jpg.svg';
        }

        if ($type === 'doc') {
            return get_template_directory_uri() . '/assets/img/doc.svg';
        }

        if ($type === 'zip') {
            return get_template_directory_uri() . '/assets/img/zip.svg';
        }

        if ($type === 'xls') {
            return get_template_directory_uri() . '/assets/img/xls.svg';
        }

        return get_template_directory_uri() . '/assets/img/other_file_type.svg';
    }

}