<?php

namespace Tangibledesign\Framework\Providers;

use Tangibledesign\Framework\Core\ServiceProvider;
use Tangibledesign\Framework\Models\Field\TaxonomyField;
use Tangibledesign\Framework\Models\Term\CustomTerm;

class FieldDependencyServiceProvider extends ServiceProvider
{
    public function initiation(): void
    {
        $this->container['dependency_terms'] = static function () {
            $terms = tdf_collect();

            tdf_taxonomy_fields()->filter(static function ($taxonomyField) {
                /* @var TaxonomyField $taxonomyField */
                return $taxonomyField->fieldDependency();
            })->each(static function ($taxonomyField) use (&$terms) {
                /* @var TaxonomyField $taxonomyField */
                $terms = $terms->merge($taxonomyField->getTermsWithFieldDependencies());
            });

            return $terms;
        };

        $this->container['main_dependency_terms'] = static function () {
            /** @noinspection NullPointerExceptionInspection */
            return tdf_app('dependency_terms')->filter(static function ($term) {
                /* @var CustomTerm $term */
                return $term->getMultiLevelParent() === 0;
            });
        };
    }
}