<?php

namespace Tangibledesign\Framework\Providers;

use Tangibledesign\Framework\Core\ServiceProvider;
use Tangibledesign\Framework\Models\Post\PostStatus;
use WP_Post;

class LiteSpeedServiceProvider extends ServiceProvider
{
    public function afterInitiation(): void
    {
        add_action('litespeed_init', [$this, 'applySettings']);

        add_filter('litespeed_vary_cookies', static function ($list) {
            $list[] = tdf_prefix() . '/compare';
            $list[] = tdf_prefix() . '/currency';

            return $list;
        });

        add_action('transition_post_status', static function (string $newStatus, string $oldStatus, WP_Post $post) {
            if ($newStatus !== PostStatus::PUBLISH || $post->post_type !== tdf_model_post_type()) {
                return;
            }

            do_action('litespeed_purged_all');
        }, 10, 3);
    }

    public function applySettings(): void
    {
        foreach ($this->getSettings() as $key => $value) {
            do_action('litespeed_conf_force', $key, $value);
        }

        if (is_user_logged_in()) {
            do_action('litespeed_control_set_nocache', 'nocache due to logged in');
        }
    }

    private function getSettings(): array
    {
        return apply_filters(tdf_prefix() . '/litespeed/config', [
            'cache-priv' => 0,
            'cache-exc' => '
                /panel/
                /login-register/
                /' . tdf_slug('user') . '/
                /' . tdf_slug('listing') . '/
            ',
            'cache-exc_roles' => [
                'administrator',
            ],
            'object-admin' => 0,
            'util-instant_click' => 1,
            'media-lazy' => 0,
            'optm-exc' => '
                /panel/
                /login-register/
            ',
            'optm-guest_only' => 1,
            'optm-exc_roles' => [
                'administrator',
            ],
            'optm-js_exc' => '
                jquery.js
                jquery.min.js
                maps
            ',
        ]);
    }
}