<?php


namespace Tangibledesign\Framework\Widgets\Helpers\Controls;


/**
 * Trait TextControls
 * @package Tangibledesign\Framework\Widgets\Helpers\Controls
 */
trait TextControls
{
    use TextColorControl;
    use TextAlignControl;
    use TypographyControl;

    /**
     * @param  string  $selector
     * @param  string  $key
     */
    protected function addTextControls(string $selector, string $key = ''): void
    {
        if (empty($key)) {
            $this->addTextColorControl($selector);

            $this->addTextAlignControl($selector);

            $this->addTypographyControl($selector);
        } else {
            $this->addTextColorControl($selector, $key);

            $this->addTextAlignControl($selector, $key);

            $this->addTypographyControl($selector, $key);
        }
    }

}