<?php


namespace Tangibledesign\Framework\Widgets\User;


use Tangibledesign\Framework\Widgets\Helpers\BaseUserWidget;
use Tangibledesign\Framework\Widgets\Helpers\Controls\TextControls;
use Tangibledesign\Framework\Widgets\Helpers\PostSingleWidget;

/**
 * Class UserDescriptionWidget
 * @package Tangibledesign\Framework\Widgets\User
 */
class UserDescriptionWidget extends BaseUserWidget implements PostSingleWidget
{
    use TextControls;

    /**
     * @return string
     */
    public function getKey(): string
    {
        return 'user_description';
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return tdf_admin_string('user_description');
    }

    protected function register_controls(): void
    {
        $this->startStyleControlsSection();

        $this->addTextControls($this->getSelector());

        $this->endControlsSection();

        $this->addVisibilitySection();
    }

    /**
     * @return string
     */
    private function getSelector(): string
    {
        return '.' . tdf_prefix() . '-user-description';
    }

}