<?php

namespace Tangibledesign\Listivo\Providers\Settings;

use Tangibledesign\Framework\Core\Settings\SettingKey;

class Settings extends \Tangibledesign\Framework\Core\Settings\Settings
{
    public static function getQuickWizardSettings(): array
    {
        return [
            SettingKey::USER_REGISTRATION,
            SettingKey::ENABLE_PAYMENTS,
            SettingKey::MODERATION,
        ];
    }

    public static function getDesignSettings(): array
    {
        return [
            SettingKey::HEADING_FONT,
            SettingKey::TEXT_FONT,
            SettingKey::PRIMARY_1_COLOR,
            SettingKey::PRIMARY_2_COLOR,
            SettingKey::PRIMARY_3_COLOR,
            SettingKey::SECONDARY_1_COLOR,
            SettingKey::SECONDARY_2_COLOR,
            SettingKey::SUPPORT_1_COLOR,
            SettingKey::CARD_LABEL_COLOR,
            SettingKey::LISTING_CARD_ATTRIBUTES,
            SettingKey::LISTING_CARD_MAIN_VALUE_FIELDS,
            SettingKey::LISTING_CARD_GALLERY_FIELD,
            SettingKey::LISTING_CARD_LOCATION,
            SettingKey::LISTING_CARD_SHOW_USER,
            SettingKey::LISTING_CARD_LABEL,
            SettingKey::LISTING_CARD_IMAGE_SIZE,
            SettingKey::LISTING_CARD_GALLERY,
            SettingKey::LISTING_CARD_GALLERY_IMAGE_NUMBER,
        ];
    }

    public static function getMonetizationSettings(): array
    {
        return [
            SettingKey::ENABLE_PAYMENTS,
            SettingKey::ENABLE_SUBSCRIPTIONS,
            SettingKey::ENABLE_BUMPS,
            SettingKey::ENABLE_FREE_LISTING,
            SettingKey::FREE_LISTING_EXPIRE,
            SettingKey::FREE_LISTING_FEATURED_EXPIRE,
            SettingKey::FREE_LISTING_BUMPS_NUMBER,
            SettingKey::FREE_LISTING_BUMPS_INTERVAL,
            SettingKey::FREE_LISTING_LABEL,
            SettingKey::FREE_LISTING_TEXT,
            SettingKey::ENABLE_REGISTER_PACKAGE,
            SettingKey::REGISTER_PACKAGE_NUMBER,
            SettingKey::REGISTER_PACKAGE_EXPIRE,
            SettingKey::REGISTER_PACKAGE_FEATURED_EXPIRE,
            SettingKey::REGISTER_PACKAGE_BUMPS_NUMBER,
            SettingKey::REGISTER_PACKAGE_BUMPS_INTERVAL,
            SettingKey::STRIPE_PUBLISHABLE_KEY,
            SettingKey::STRIPE_SECRET_KEY,
            SettingKey::STRIPE_ENABLED,
            SettingKey::STRIPE_WEBHOOK_SECRET,
            SettingKey::STRIPE_CURRENCY,
            SettingKey::STRIPE_REQUIRE_BILLING_ADDRESS_COLLECTION,
            SettingKey::STRIPE_ALLOW_PROMOTION_CODES,
            SettingKey::ENABLE_FREE_SUBSCRIPTION,
            SettingKey::FREE_SUBSCRIPTION_NAME,
            SettingKey::FREE_SUBSCRIPTION_LABEL,
            SettingKey::FREE_SUBSCRIPTION_TEXT,
            SettingKey::FREE_SUBSCRIPTION_NUMBER,
            SettingKey::FREE_SUBSCRIPTION_EXPIRE,
            SettingKey::FREE_SUBSCRIPTION_FEATURED_EXPIRE,
            SettingKey::FREE_SUBSCRIPTION_BUMPS_NUMBER,
            SettingKey::FREE_SUBSCRIPTION_BUMPS_INTERVAL,
            SettingKey::SUBSCRIPTION_RENEWAL_POLICY,
        ];
    }

    public static function getUserPanelSettings(): array
    {
        return [
            SettingKey::MODERATION,
            SettingKey::MODERATION_RE_APPROVE,
            SettingKey::USER_REGISTRATION,
            SettingKey::RE_CAPTCHA,
            SettingKey::RE_CAPTCHA_SITE_KEY,
            SettingKey::RE_CAPTCHA_SECRET_KEY,
            SettingKey::FACEBOOK_AUTH,
            SettingKey::FACEBOOK_AUTH_APP_ID,
            SettingKey::FACEBOOK_AUTH_APP_SECRET,
            SettingKey::GOOGLE_AUTH,
            SettingKey::GOOGLE_AUTH_CLIENT_ID,
            SettingKey::GOOGLE_AUTH_CLIENT_SECRET,
            SettingKey::POLICY_LABEL,
            SettingKey::DESCRIPTION_REQUIRED,
            SettingKey::NAME_REQUIRED,
            SettingKey::DESCRIPTION_SIMPLE_EDITOR,
            SettingKey::SUBMIT_WITHOUT_LOGIN,
            SettingKey::MAIN_CATEGORY,
            SettingKey::MODERATORS,
            SettingKey::PHONE_LOGIC,
            SettingKey::ACCOUNT_INITIAL_TAB,
            SettingKey::LOGIN_MIN_LENGTH,
            SettingKey::DISABLE_VIBER,
            SettingKey::DISABLE_WHATS_APP,
            SettingKey::ACCOUNT_TYPE,
            SettingKey::CAN_USER_CHANGE_ACCOUNT_TYPE,
            SettingKey::USER_EMAIL_CONFIRMATION,
            SettingKey::ENABLE_WEBSITE_FIELD,
            SettingKey::ENABLE_COMPANY_INFORMATION,
            SettingKey::REQUIRE_COMPANY_INFORMATION,
            SettingKey::SHOW_REGISTER_FORM_COMPANY_INFORMATION,
            SettingKey::ENABLE_PRIVATE_ACCOUNT_FULL_NAME,
            SettingKey::REQUIRE_PRIVATE_ACCOUNT_FULL_NAME,
            SettingKey::SHOW_REGISTER_FORM_PRIVATE_ACCOUNT_FULL_NAME,
            SettingKey::ENABLE_BUSINESS_ACCOUNT_FULL_NAME,
            SettingKey::REQUIRE_BUSINESS_ACCOUNT_FULL_NAME,
            SettingKey::SHOW_REGISTER_FORM_BUSINESS_ACCOUNT_FULL_NAME,
            SettingKey::NAME_LENGTH,
            SettingKey::NAME_HINT,
            SettingKey::DESCRIPTION_HINT,
            SettingKey::LOGIN_REDIRECT,
            SettingKey::REGISTER_REDIRECT,
            SettingKey::SOCIAL_LOGIN_REDIRECT,
            SettingKey::SOCIAL_REGISTER_REDIRECT,
            SettingKey::PHONE_COUNTRY_CODE_SELECT,
            SettingKey::PHONE_DEFAULT_COUNTRY_CODE,
            SettingKey::DISABLE_PRIVATE_ROLE_MODELS,
            SettingKey::DISABLE_BUSINESS_ROLE_MODELS,
            SettingKey::MARKETING_CONSENTS,
            SettingKey::MARKETING_CONSENTS_REQUIRED,
            SettingKey::MARKETING_CONSENTS_DEFAULT,
            SettingKey::MARKETING_CONSENTS_LABEL,
            SettingKey::LISTING_EXPIRE_AFTER,
            SettingKey::LISTING_TERMS_AND_CONDITIONS,
            SettingKey::ACTIVATE_CHAT_APPS_ON_REGISTRATION,
            SettingKey::MODERATION_PAGE_CUSTOM_FIELDS,
        ];
    }

    public static function getBasicSettings(): array
    {
        return [
            SettingKey::LOGO,
            SettingKey::INVERSE_LOGO,
            SettingKey::HOMEPAGE,
            SettingKey::MAIL,
            SettingKey::PHONE,
            SettingKey::ADDRESS,
            SettingKey::MAIN_MENU,
            SettingKey::SHOW_MENU_CTA_BUTTON,
            SettingKey::CUSTOM_MENU_CTA_TEXT,
            SettingKey::MENU_CTA_BUTTON_PAGE,
            SettingKey::SHOW_MENU_ACCOUNT,
            SettingKey::STICKY_MAIN_MENU,
            SettingKey::COPYRIGHTS_TEXT,
            SettingKey::FACEBOOK_PROFILE,
            SettingKey::INSTAGRAM_PROFILE,
            SettingKey::TWITTER_PROFILE,
            SettingKey::LINKED_IN_PROFILE,
            SettingKey::YOU_TUBE_PROFILE,
            SettingKey::TIKTOK_PROFILE,
            SettingKey::TELEGRAM_PROFILE,
            SettingKey::FACEBOOK_API_KEY,
            SettingKey::DECIMAL_SEPARATOR,
            SettingKey::THOUSANDS_SEPARATOR,
            SettingKey::DISABLE_DEMO_IMPORTER,
            SettingKey::BREADCRUMBS,
            SettingKey::PRETTY_URLS,
            SettingKey::EXCLUDE_FROM_SEARCH,
            SettingKey::DELETE_MODEL_IMAGES_ON_DELETE,
            SettingKey::AUTO_GENERATE_MODEL_TITLE,
            SettingKey::KEYWORD_SEARCH_DESCRIPTION,
            SettingKey::KEYWORD_SEARCH_TERMS,
            SettingKey::SEARCH_DEFAULT_TITLE,
            SettingKey::SEARCH_DEFAULT_DESCRIPTION,
            SettingKey::SEARCH_TITLE_FIELDS,
            SettingKey::SECOND_SEARCH_TITLE_FIELDS,
            SettingKey::SEARCH_OVERRIDE_TITLE_TAG,
            SettingKey::COMPARE_MODELS,
            SettingKey::QUICK_VIEW,
            SettingKey::FAVORITE,
            SettingKey::MESSAGE_SYSTEM,
            SettingKey::MESSAGE_SYSTEM_INITIAL_MESSAGE,
            SettingKey::GOOGLE_MAPS_API_KEY,
            SettingKey::MAP_LANGUAGE,
            SettingKey::MAP_ZOOM_LEVEL,
            SettingKey::MAP_SNAZZY,
            SettingKey::MAP_INITIAL_LOCATION,
            SettingKey::MAP_DEFAULT_RADIUS,
            SettingKey::MAP_RADIUS_UNIT,
            SettingKey::MAP_PROVIDER,
            SettingKey::TWILIO_ACCOUNT_SID,
            SettingKey::TWILIO_AUTH_TOKEN,
            SettingKey::TWILIO_PHONE_NUMBER,
            SettingKey::TWILIO_VERIFY_SERVICE_SID,
            SettingKey::USER_PHONE_VERIFICATION,
            SettingKey::REVIEWS_ENABLED,
            SettingKey::REVIEWS_MODERATION_ENABLED,
            SettingKey::REVIEWS_THUMBS_ENABLED,
            SettingKey::REVIEWS_IMAGES_ENABLED,
            SettingKey::REVIEWS_IMAGES_NUMBER,
            SettingKey::REVIEWS_IMAGES_SIZE,
            SettingKey::REVIEWS_ALLOW_GUESTS,
            SettingKey::REVIEW_MIN_LENGTH,
            SettingKey::REVIEW_MAX_LENGTH,
            SettingKey::REVIEW_CUTOFF_LENGTH,
            SettingKey::DELETE_REVIEW_IMAGES_ON_DELETE,
            SettingKey::SINGLE_REVIEW_PER_MODEL,
            SettingKey::ENABLE_CACHE,
            SettingKey::CACHE_DURATION,
        ];
    }

    public static function getAdvancedSettings(): array
    {
        return [
            SettingKey::ADDITIONAL_SEARCH_PAGES,
            SettingKey::BLOG_PAGE,
            SettingKey::ERROR_PAGE,
            SettingKey::LOGIN_PAGE,
            SettingKey::REGISTER_PAGE,
            SettingKey::PANEL_PAGE,
            SettingKey::CONTACT_USER_FORM,
            SettingKey::COMPARE_PAGE,
            SettingKey::LEGACY_MODE,
        ];
    }
}