<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\ContactForm;
use Tangibledesign\Framework\Models\Page;
use Tangibledesign\Listivo\Providers\Settings\SettingsServiceProvider;

?>
<form
        action="<?php echo esc_url(tdf_action_url(tdf_prefix() . '/settings/save&type=' . SettingsServiceProvider::TYPE_ADVANCED)); ?>"
        method="post"
>
    <input
            type="hidden"
            name="redirect"
            value="<?php echo esc_url(admin_url('admin.php?page=listivo_advanced')); ?>"
    >

    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::ADDITIONAL_SEARCH_PAGES); ?>">
                    <?php esc_html_e('Additional Search Pages', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::ADDITIONAL_SEARCH_PAGES); ?>"
                        name="<?php echo esc_attr(SettingKey::ADDITIONAL_SEARCH_PAGES); ?>[]"
                        class="tdf-selectize tdf-selectize-init"
                        placeholder="<?php esc_attr_e('Not Set', 'listivo-core'); ?>"
                        multiple
                >
                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (in_array($lstPage->getId(), tdf_settings()->getAdditionalSearchPagesIds(), true)) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::PANEL_PAGE); ?>">
                    <?php esc_html_e('Panel Page', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::PANEL_PAGE); ?>"
                        name="<?php echo esc_attr(SettingKey::PANEL_PAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (tdf_settings()->getPanelPageId() === $lstPage->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::COMPARE_PAGE); ?>">
                    <?php esc_html_e('Compare Page', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::COMPARE_PAGE); ?>"
                        name="<?php echo esc_attr(SettingKey::COMPARE_PAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (tdf_settings()->getComparePageId() === $lstPage->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::LOGIN_PAGE); ?>">
                    <?php esc_html_e('Login Page', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::LOGIN_PAGE); ?>"
                        name="<?php echo esc_attr(SettingKey::LOGIN_PAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (tdf_settings()->getLoginPageId() === $lstPage->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::REGISTER_PAGE); ?>">
                    <?php esc_html_e('Register Page', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::REGISTER_PAGE); ?>"
                        name="<?php echo esc_attr(SettingKey::REGISTER_PAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (tdf_settings()->getRegisterPageId() === $lstPage->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::BLOG_PAGE); ?>">
                    <?php esc_html_e('Blog Page', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::BLOG_PAGE); ?>"
                        name="<?php echo esc_attr(SettingKey::BLOG_PAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (tdf_settings()->getBlogPageId() === $lstPage->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::ERROR_PAGE); ?>">
                    <?php esc_html_e('Error Page', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::ERROR_PAGE); ?>"
                        name="<?php echo esc_attr(SettingKey::ERROR_PAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                        <option
                                value="<?php echo esc_attr($lstPage->getId()); ?>"
                            <?php if (tdf_settings()->getErrorPageId() === $lstPage->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstPage->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::CONTACT_USER_FORM); ?>">
                    <?php esc_html_e('Contact User Form', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        id="<?php echo esc_attr(SettingKey::CONTACT_USER_FORM); ?>"
                        name="<?php echo esc_attr(SettingKey::CONTACT_USER_FORM); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <option value="0">
                        <?php esc_html_e('Not set', 'listivo-core'); ?>
                    </option>

                    <?php foreach (tdf_app('contact_forms') as $lstContactForm) : /* @var ContactForm $lstContactForm */ ?>
                        <option
                                value="<?php echo esc_attr($lstContactForm->getId()); ?>"
                            <?php if (tdf_settings()->getContactUserFormId() === $lstContactForm->getId()) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstContactForm->getName()); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::LEGACY_MODE); ?>">
                    <?php esc_html_e('Legacy Mode', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <label for="<?php echo esc_attr(SettingKey::LEGACY_MODE); ?>">
                    <input
                            name="<?php echo esc_attr(SettingKey::LEGACY_MODE); ?>"
                            id="<?php echo esc_attr(SettingKey::LEGACY_MODE); ?>"
                            type="checkbox"
                            value="1"
                        <?php if (tdf_settings()->isLegacyModeEnabled()) : ?>
                            checked
                        <?php endif; ?>
                    >
                </label>
            </td>
        </tr>
        </tbody>
    </table>

    <p class="submit">
        <button class="button button-primary">
            <?php esc_html_e('Save Changes', 'listivo-core'); ?>
        </button>
    </p>
</form>