<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\ContactForm;
use Tangibledesign\Framework\Models\Field\TaxonomyField;
use Tangibledesign\Framework\Models\Page;

?>
<form
        action="<?php echo esc_url(tdf_action_url(tdf_prefix() . '/termImporter/import')); ?>"
        method="post"
>
    <lst-term-importer>
        <div slot-scope="importer">
            <table class="form-table">
                <tbody>
                <tr>
                    <th scope="row">
                        <label for="tdf-parent-taxonomy">
                            <?php esc_html_e('Taxonomy', 'listivo-core'); ?>
                        </label>
                    </th>

                    <td>
                        <select
                                id="tdf-parent-taxonomy"
                                name="parent_taxonomy"
                                @change="importer.setTaxonomy($event.target.value)"
                                :value="importer.taxonomy"

                        >
                            <option value="0">
                                <?php esc_html_e('Select', 'listivo-core'); ?>
                            </option>

                            <?php foreach (tdf_taxonomy_fields() as $tdfTaxonomyField):
                                /* @var TaxonomyField $tdfTaxonomyField */
                                ?>
                                <option value="<?php echo esc_attr($tdfTaxonomyField->getKey()); ?>">
                                    <?php echo esc_html($tdfTaxonomyField->getName()); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th scope="row">
                        <label for="tdf-parent-terms">
                            <?php esc_html_e('Terms', 'listivo-core'); ?>
                        </label>
                    </th>

                    <td>
                        <textarea
                                id="tdf-parent-terms"
                                name="parent_terms"
                                class="listivo-backend-text-area"
                                cols="30"
                                rows="10"
                        ></textarea>
                    </td>
                </tr>

                <?php foreach (tdf_app('child_taxonomies') as $tdfTaxonomy) :
                    /* @var TaxonomyField $tdfTaxonomy */
                    foreach ($tdfTaxonomy->getParentTaxonomyFields() as $tdfParentTaxonomy) :?>
                        <tr v-if="importer.taxonomy === '<?php echo esc_attr($tdfParentTaxonomy->getKey()); ?>'">
                            <th class="row">
                                <label for="child_taxonomy">
                                    <?php echo sprintf(esc_html__('%s (Optional)', 'listivo-core'), $tdfTaxonomy->getName()); ?>
                                </label>
                            </th>

                            <td>
                                <input
                                        type="hidden"
                                        name="child_taxonomy[]"
                                        value="<?php echo esc_attr($tdfTaxonomy->getKey()); ?>"
                                >

                                <textarea
                                        name="child_terms[]"
                                        id="tdf-child-terms"
                                        class="listivo-backend-text-area"
                                        cols="30"
                                        rows="10"
                                ></textarea>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endforeach; ?>
                </tbody>
            </table>

            <p class="submit">
                <button class="button button-primary">
                    <?php esc_html_e('Import', 'listivo-core'); ?>
                </button>
            </p>
        </div>
    </lst-term-importer>
</form>