<table class="form-table">
    <tbody>
    <tr>
        <th scope="row">
            <label>
                <?php esc_html_e('Expired Ads', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <a
                    class="button button-secondary"
                    href="<?php echo esc_url(tdf_action_url(tdf_prefix() . '/models/checkExpired')); ?>"
            >
                <?php esc_html_e('Check Expired', 'listivo-core'); ?>
            </a>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label>
                <?php esc_html_e('Connect Terms', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <a
                    class="button button-secondary"
                    href="<?php echo esc_url(tdf_action_url(tdf_prefix() . '/term/relations/connect')); ?>"
            >
                <?php esc_html_e('Connect Terms', 'listivo-core'); ?>
            </a>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label>
                <?php esc_html_e('Files', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <a
                    class="button button-secondary"
                    href="<?php echo esc_url(tdf_action_url('listivo/images/cleanUp')); ?>"
            >
                <?php
                echo sprintf(
                    esc_html__('Clear Files (%d)', 'listivo-core'),
                    tdf_app('imagesToDeleteCount')
                );
                ?>
            </a>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label>
                <?php esc_html_e('Order by most relevant', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <a
                    class="button button-secondary"
                    href="<?php echo esc_url(tdf_action_url('listivo/bugs/featured')); ?>"
            >
                <?php esc_html_e('Fix order by most relevant when using WP All Import'); ?>
            </a>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label>
                <?php echo sprintf(esc_html__('Regenerate %s titles', 'listivo-core'), tdf_string('listings')); ?>
            </label>
        </th>

        <td>
            <lst-generate-model-titles
                    request-url="<?php echo esc_url(tdf_action_url(tdf_prefix() . '/model/regenerate-titles')); ?>"
                    :count="<?php echo esc_attr(tdf_app('models_count')); ?>"
            >
                <div slot-scope="props">
                    <div v-if="!props.isDone">
                        <div v-if="!props.inProgress">
                            <button
                                    class="button button-secondary"
                                    @click="props.onStart"
                            >
                                <?php esc_html_e('Regenerate', 'listivo-core'); ?>
                            </button>

                            <p class="listivo-backend-description">
                                <?php esc_html_e('Note: This applies only when the "Settings -> SEO -> Auto-generate Title" option is enabled.', 'listivo-core'); ?>
                            </p>
                        </div>

                        <div v-if="props.inProgress">
                            <div class="spinner is-active" style="float:left;"></div>
                        </div>
                    </div>

                    <div v-if="props.isDone">
                        <strong><?php esc_html_e('Finished!', 'listivo-core'); ?></strong>
                    </div>
                </div>
            </lst-generate-model-titles>
        </td>
    </tr>
    </tbody>
</table>