<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\Page;

?>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row">
            <label for="logo">
                <?php esc_html_e('Logo Default', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <lst-set-image :initial-image-id="<?php echo esc_attr(tdf_settings()->getLogoId()); ?>">
                <div slot-scope="props">
                    <div v-if="props.imageId" class="listivo-backend-add-logo">
                        <img :src="props.imageUrl" alt="">

                        <button class="listivo-backend-add-logo__remove" @click.prevent="props.remove"></button>

                        <input
                                name="<?php echo esc_attr(SettingKey::LOGO); ?>"
                                :value="props.imageId"
                                type="hidden"
                        >
                    </div>

                    <button
                            class="button button-secondary"
                            @click.prevent="props.openUploader"
                    >
                        <?php esc_html_e('Set Logo', 'listivo-core'); ?>
                    </button>
                </div>
            </lst-set-image>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="logo_reversed">
                <?php esc_html_e('Logo Reversed', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <lst-set-image :initial-image-id="<?php echo esc_attr(tdf_settings()->getInverseLogoId()); ?>">
                <div slot-scope="props">
                    <div class="listivo-backend-add-logo listivo-backend-add-logo--inverse" v-if="props.imageId">
                        <img :src="props.imageUrl" alt="">

                        <button class="listivo-backend-add-logo__remove" @click.prevent="props.remove"></button>

                        <input
                                name="<?php echo esc_attr(SettingKey::INVERSE_LOGO); ?>"
                                :value="props.imageId"
                                type="hidden"
                        >
                    </div>

                    <button
                            class="button button-secondary"
                            @click.prevent="props.openUploader"
                    >
                        <?php esc_html_e('Set Logo', 'listivo-core'); ?>
                    </button>
                </div>
            </lst-set-image>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::HOMEPAGE); ?>">
                <?php esc_html_e('Homepage', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                    name="<?php echo esc_attr(SettingKey::HOMEPAGE); ?>"
                    id="<?php echo esc_attr(SettingKey::HOMEPAGE); ?>"
            >
                <option value="0">
                    <?php esc_html_e('Not set', 'listivo-core'); ?>
                </option>

                <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                    <option
                            value="<?php echo esc_attr($lstPage->getId()); ?>"
                        <?php if (tdf_settings()->getHomepageId() === $lstPage->getId()) : ?>
                            selected
                        <?php endif; ?>
                    >
                        <?php echo esc_html($lstPage->getName()); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::MAIL); ?>">
                <?php esc_html_e('Public Email', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                    id="<?php echo esc_attr(SettingKey::MAIL); ?>"
                    name="<?php echo esc_attr(SettingKey::MAIL); ?>"
                    class="regular-text"
                    type="text"
                    value="<?php echo esc_attr(tdf_settings()->getMail()); ?>"
            >
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::PHONE); ?>">
                <?php esc_html_e('Public Phone', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                    id="<?php echo esc_attr(SettingKey::PHONE); ?>"
                    name="<?php echo esc_attr(SettingKey::PHONE); ?>"
                    class="regular-text"
                    type="text"
                    value="<?php echo esc_attr(tdf_settings()->getPhone()); ?>"
            >
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::ADDRESS); ?>">
                <?php esc_html_e('Public Address', 'listivo-core'); ?>
            </label>
        </th>

        <td>
                <textarea
                        id="<?php echo esc_attr(SettingKey::ADDRESS); ?>"
                        name="<?php echo esc_attr(SettingKey::ADDRESS); ?>"
                        class="listivo-backend-text-area"
                        rows="5"
                        cols="30"
                ><?php echo esc_html(tdf_settings()->getAddress()); ?></textarea>

        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::COPYRIGHTS_TEXT); ?>">
                <?php esc_html_e('Copyright Notice', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                    id="<?php echo esc_attr(SettingKey::COPYRIGHTS_TEXT); ?>"
                    name="<?php echo esc_attr(SettingKey::COPYRIGHTS_TEXT); ?>"
                    class="regular-text"
                    type="text"
                    value="<?php echo esc_html(tdf_settings()->getCopyrightsText()); ?>"
            >
        </td>
    </tr>
    </tbody>
</table>

<p class="submit">
    <button class="button button-primary">
        <?php esc_html_e('Save Changes', 'listivo-core'); ?>
    </button>
</p>