<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\Menu;
use Tangibledesign\Framework\Models\Page;

?>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::MAP_PROVIDER); ?>">
                <?php esc_html_e('Map Provider', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                    id="<?php echo esc_attr(SettingKey::MAP_PROVIDER); ?>"
                    name="<?php echo esc_attr(SettingKey::MAP_PROVIDER); ?>"
                    class="tdf-selectize tdf-selectize-init"
            >
                <option
                        value="<?php echo esc_attr(SettingKey::MAP_PROVIDER_GOOGLE_MAPS); ?>"
                    <?php if (tdf_settings()->getMapProvider() === SettingKey::MAP_PROVIDER_GOOGLE_MAPS) : ?>
                        selected
                    <?php endif; ?>
                >
                    <?php esc_html_e('Google Maps', 'listivo-core'); ?>
                </option>

                <option
                        value="<?php echo esc_attr(SettingKey::MAP_PROVIDER_OPEN_STREET_MAP); ?>"
                    <?php if (tdf_settings()->getMapProvider() === SettingKey::MAP_PROVIDER_OPEN_STREET_MAP) : ?>
                        selected
                    <?php endif; ?>
                >
                    <?php esc_html_e('Open Street Map', 'listivo-core'); ?>
                </option>
            </select>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::GOOGLE_MAPS_API_KEY); ?>">
                <?php esc_html_e('Google Maps API Key', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <label for="<?php echo esc_attr(SettingKey::GOOGLE_MAPS_API_KEY); ?>">
                <input
                        name="<?php echo esc_attr(SettingKey::GOOGLE_MAPS_API_KEY); ?>"
                        id="<?php echo esc_attr(SettingKey::GOOGLE_MAPS_API_KEY); ?>"
                        class="regular-text"
                        type="text"
                        value="<?php echo esc_attr(tdf_settings()->getGoogleMapsApiKey()); ?>"
                >

                <p class="description">
                    <a
                            href="https://support.listivotheme.com/support/solutions/articles/101000373809-how-to-turn-on-google-maps-how-to-obtain-google-maps-api-key"
                            target="_blank"
                    >
                        <?php esc_html_e('Learn how to get api key', 'listivo-core'); ?>
                    </a>
                </p>
            </label>
        </td>
    </tr>

    <?php if (!empty(tdf_settings()->getGoogleMapsApiKey())) : ?>
        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::MAP_INITIAL_LOCATION); ?>">
                    <?php esc_html_e('Initial Location', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <lst-set-location
                        map-id="listivo-initial-location"
                        input-id="<?php echo esc_attr(SettingKey::MAP_INITIAL_LOCATION); ?>"
                        :initial-location="<?php echo htmlspecialchars(json_encode(tdf_settings()->getMapInitialLocation())); ?>"
                        :initial-zoom-level="<?php echo esc_attr(tdf_settings()->getMapZoomLevel()); ?>"
                >
                    <div slot-scope="props">
                        <input
                                name="<?php echo esc_attr(SettingKey::MAP_INITIAL_LOCATION); ?>[lat]"
                                type="hidden"
                                :value="props.location.lat"
                        >

                        <input
                                name="<?php echo esc_attr(SettingKey::MAP_INITIAL_LOCATION); ?>[lng]"
                                type="hidden"
                                :value="props.location.lng"
                        >

                        <p>
                            <input
                                    id="<?php echo esc_attr(SettingKey::MAP_INITIAL_LOCATION); ?>"
                                    class="regular-text"
                                    type="text"
                            >
                        </p>

                        <div>
                            <div
                                    id="listivo-initial-location"
                                    class="tdf-map-initial-location"
                            ></div>
                        </div>

                        <p v-if="props.apiKeyError" class="description">
                            <?php esc_html_e('Invalid Google Maps Api Key', 'listivo-core'); ?>
                        </p>
                    </div>
                </lst-set-location>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::MAP_ZOOM_LEVEL); ?>">
                    <?php esc_html_e('Zoom Level', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <label for="<?php echo esc_attr(SettingKey::MAP_ZOOM_LEVEL); ?>">
                    <input
                            name="<?php echo esc_attr(SettingKey::MAP_ZOOM_LEVEL); ?>"
                            id="<?php echo esc_attr(SettingKey::MAP_ZOOM_LEVEL); ?>"
                            class="regular-text"
                            type="text"
                            value="<?php echo esc_attr(tdf_settings()->getMapZoomLevel()); ?>"
                    >
                </label>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::MAP_DEFAULT_RADIUS); ?>">
                    <?php esc_html_e('Default Radius', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <label for="<?php echo esc_attr(SettingKey::MAP_DEFAULT_RADIUS); ?>">
                    <input
                            name="<?php echo esc_attr(SettingKey::MAP_DEFAULT_RADIUS); ?>"
                            id="<?php echo esc_attr(SettingKey::MAP_DEFAULT_RADIUS); ?>"
                            class="regular-text"
                            type="text"
                            value="<?php echo esc_attr(tdf_settings()->getMapDefaultRadius()); ?>"
                    >
                </label>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::MAP_RADIUS_UNIT); ?>">
                    <?php esc_html_e('Radius Unit', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <label for="<?php echo esc_attr(SettingKey::MAP_RADIUS_UNIT); ?>">
                    <select
                            name="<?php echo esc_attr(SettingKey::MAP_RADIUS_UNIT); ?>"
                            id="<?php echo esc_attr(SettingKey::MAP_RADIUS_UNIT); ?>"
                            class="tdf-selectize tdf-selectize-init"
                    >
                        <option
                                value="<?php echo esc_attr(SettingKey::MAP_RADIUS_UNIT_KM); ?>"
                            <?php if (tdf_settings()->getMapRadiusUnit() === SettingKey::MAP_RADIUS_UNIT_KM) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php esc_attr_e('KM', 'listivo-core'); ?>
                        </option>

                        <option
                                value="<?php echo esc_attr(SettingKey::MAP_RADIUS_UNIT_MILES); ?>"
                            <?php if (tdf_settings()->getMapRadiusUnit() === SettingKey::MAP_RADIUS_UNIT_MILES) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php esc_attr_e('Miles', 'listivo-core'); ?>
                        </option>
                    </select>
                </label>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::MAP_LANGUAGE); ?>">
                    <?php esc_html_e('Language', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <select
                        name="<?php echo esc_attr(SettingKey::MAP_LANGUAGE); ?>"
                        id="<?php echo esc_attr(SettingKey::MAP_LANGUAGE); ?>"
                        class="tdf-selectize tdf-selectize-init"
                >
                    <?php foreach (tdf_app('google_map_languages') as $lstLanguageCode => $lstLanguageName) : ?>
                        <option
                                value="<?php echo esc_attr($lstLanguageCode); ?>"
                            <?php if (tdf_settings()->getMapLanguage() === $lstLanguageCode) : ?>
                                selected
                            <?php endif; ?>
                        >
                            <?php echo esc_html($lstLanguageName); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="<?php echo esc_attr(SettingKey::MAP_SNAZZY); ?>">
                    <?php esc_html_e('Snazzy', 'listivo-core'); ?>
                </label>
            </th>

            <td>
                <textarea
                        name="<?php echo esc_attr(SettingKey::MAP_SNAZZY); ?>"
                        id="<?php echo esc_attr(SettingKey::MAP_SNAZZY); ?>"
                        class="listivo-backend-text-area"
                        rows="5"
                        cols="30"
                ><?php echo tdf_settings()->getMapSnazzy(); ?></textarea>
            </td>
        </tr>
    <?php endif; ?>
    </tbody>
</table>

<p class="submit">
    <button class="button button-primary">
        <?php esc_html_e('Save Changes', 'listivo-core'); ?>
    </button>
</p>