<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\Menu;
use Tangibledesign\Framework\Models\Page;

?>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::MAIN_MENU); ?>">
                <?php esc_html_e('Menu', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                id="<?php echo esc_attr(SettingKey::MAIN_MENU); ?>"
                name="<?php echo esc_attr(SettingKey::MAIN_MENU); ?>"
            >
                <option value="0">
                    <?php esc_html_e('Not set', 'listivo-core'); ?>
                </option>

                <?php foreach (tdf_app('menus') as $lstMenu) : /* @var Menu $lstMenu */ ?>
                    <option
                        value="<?php echo esc_attr($lstMenu->getID()); ?>"
                        <?php if (tdf_settings()->getMainMenuId() === $lstMenu->getID()) : ?>
                            selected
                        <?php endif; ?>
                    >
                        <?php echo esc_html($lstMenu->getName()); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::STICKY_MAIN_MENU); ?>">
                <?php esc_html_e('Sticky', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                id="<?php echo esc_attr(SettingKey::STICKY_MAIN_MENU); ?>"
                name="<?php echo esc_attr(SettingKey::STICKY_MAIN_MENU); ?>"
                type="checkbox"
                value="1"
                <?php if (tdf_settings()->isMainMenuSticky()) : ?>
                    checked
                <?php endif; ?>
            >
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SHOW_MENU_ACCOUNT); ?>">
                <?php esc_html_e('User Menu', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <label>
                <input
                    id="<?php echo esc_attr(SettingKey::SHOW_MENU_ACCOUNT); ?>"
                    name="<?php echo esc_attr(SettingKey::SHOW_MENU_ACCOUNT); ?>"
                    type="checkbox"
                    value="1"
                    <?php if (tdf_settings()->showMenuAccount()) : ?>
                        checked
                    <?php endif; ?>
                >

                <?php esc_html_e('Show user menu for logged in and "login / register" for not logged in.',
                    'listivo-core'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SHOW_MENU_CTA_BUTTON); ?>">
                <?php esc_html_e('CTA Button', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                id="<?php echo esc_attr(SettingKey::SHOW_MENU_CTA_BUTTON); ?>"
                name="<?php echo esc_attr(SettingKey::SHOW_MENU_CTA_BUTTON); ?>"
                type="checkbox"
                value="1"
                <?php if (tdf_settings()->showMenuCtaButton()) : ?>
                    checked
                <?php endif; ?>
            >
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::MENU_CTA_BUTTON_PAGE); ?>">
                <?php esc_html_e('CTA Button Link', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                id="<?php echo esc_attr(SettingKey::MENU_CTA_BUTTON_PAGE); ?>"
                name="<?php echo esc_attr(SettingKey::MENU_CTA_BUTTON_PAGE); ?>"
            >
                <option value="0">
                    <?php esc_html_e('Add Listing', 'listivo-core'); ?>
                </option>

                <option
                    value="-1"
                    <?php if (tdf_settings()->getMenuCtaButtonPageId()) : ?>
                        selected
                    <?php endif; ?>
                >
                    <?php esc_html_e('Search Results', 'listivo-core'); ?>
                </option>

                <?php foreach (tdf_app('pages') as $lstPage) : /* @var Page $lstPage */ ?>
                    <option
                        value="<?php echo esc_attr($lstPage->getId()); ?>"
                        <?php if (tdf_settings()->getMenuCtaButtonPageId() === $lstPage->getId()) : ?>
                            selected
                        <?php endif; ?>
                    >
                        <?php echo esc_html($lstPage->getName()); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::CUSTOM_MENU_CTA_TEXT); ?>">
                <?php esc_html_e('Custom CTA Button Text', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                id="<?php echo esc_attr(SettingKey::CUSTOM_MENU_CTA_TEXT); ?>"
                name="<?php echo esc_attr(SettingKey::CUSTOM_MENU_CTA_TEXT); ?>"
                class="regular-text"
                type="text"
                value="<?php echo esc_attr(tdf_settings()->getCustomMenuCtaText()); ?>"
            >
        </td>
    </tr>
    </tbody>
</table>

<p class="submit">
    <button class="button button-primary">
        <?php esc_html_e('Save Changes', 'listivo-core'); ?>
    </button>
</p>