<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\Field\Helpers\SimpleTextValue;
use Tangibledesign\Framework\Models\Field\TaxonomyField;

?>
<table class="form-table">
    <tbody>
    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::BREADCRUMBS); ?>">
                <?php esc_html_e('Breadcrumbs', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                    id="<?php echo esc_attr(SettingKey::BREADCRUMBS); ?>"
                    name="<?php echo esc_attr(SettingKey::BREADCRUMBS); ?>[]"
                    class="tdf-selectize tdf-selectize-init"
                    multiple
            >
                <?php foreach (tdf_settings()->getBreadcrumbs() as $tdfTaxonomyKey) :
                    $tdfTaxonomyField = tdf_taxonomy_fields()->find(static function ($taxonomy) use ($tdfTaxonomyKey) {
                        /* @var TaxonomyField $taxonomy */
                        return $taxonomy->getKey() === $tdfTaxonomyKey;
                    });

                    if (!$tdfTaxonomyField instanceof TaxonomyField) {
                        continue;
                    }
                    ?>
                    <option value="<?php echo esc_attr($tdfTaxonomyField->getKey()); ?>" selected>
                        <?php echo esc_html($tdfTaxonomyField->getName()); ?> <i class="fas fa-arrow-right"></i>
                    </option>
                <?php endforeach; ?>

                <?php foreach (tdf_taxonomy_fields() as $tdfTaxonomyField) :
                    if (in_array($tdfTaxonomyField->getKey(), tdf_settings()->getBreadcrumbs(), true)) {
                        continue;
                    }
                    ?>
                    <option value="<?php echo esc_attr($tdfTaxonomyField->getKey()); ?>">
                        <?php echo esc_html($tdfTaxonomyField->getName()); ?> <i class="fas fa-arrow-right"></i>
                    </option>
                <?php endforeach; ?>
            </select>

            <p class="description">
                <?php esc_html_e('These fields will be used to generate breadcrumbs.', 'listivo-core'); ?>
            </p>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::PRETTY_URLS); ?>">
                <?php esc_html_e('Pretty URL\'s', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <label for="<?php echo esc_attr(SettingKey::PRETTY_URLS); ?>">
                <input
                        name="<?php echo esc_attr(SettingKey::PRETTY_URLS); ?>"
                        id="<?php echo esc_attr(SettingKey::PRETTY_URLS); ?>"
                        type="checkbox"
                        value="1"
                    <?php if (tdf_settings()->prettyUrls()) : ?>
                        checked
                    <?php endif; ?>
                >

                <?php esc_html_e('Generate pretty urls based on breadcrumbs settings. Slugs for search results and specific ad must be different.', 'listivo-core'); ?>
            </label>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::AUTO_GENERATE_MODEL_TITLE); ?>">
                <?php esc_html_e('Auto-Generate Ad Title', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                    id="<?php echo esc_attr(SettingKey::AUTO_GENERATE_MODEL_TITLE); ?>"
                    name="<?php echo esc_attr(SettingKey::AUTO_GENERATE_MODEL_TITLE); ?>[]"
                    class="tdf-selectize tdf-selectize-init"
                    placeholder="<?php esc_attr_e('Do not auto generate - user enter title manually', 'listivo-core'); ?>"
                    multiple
            >
                <?php foreach (tdf_settings()->getAutoGenerateModelTitleFields() as $lstField) : /* @var SimpleTextValue $lstField */ ?>
                    <option
                            value="<?php echo esc_attr($lstField->getId()); ?>"
                            selected
                    >
                        <?php echo esc_html($lstField->getName()); ?>
                    </option>
                <?php endforeach; ?>

                <?php foreach (tdf_settings()->getNotAutoGenerateModelTitleFields() as $lstField) : /* @var SimpleTextValue $lstField */ ?>
                    <option value="<?php echo esc_attr($lstField->getId()); ?>">
                        <?php echo esc_html($lstField->getName()); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SEARCH_DEFAULT_DESCRIPTION); ?>">
                <?php esc_html_e('Default Search Description', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <textarea
                    id="<?php echo esc_attr(SettingKey::SEARCH_DEFAULT_DESCRIPTION); ?>"
                    name="<?php echo esc_attr(SettingKey::SEARCH_DEFAULT_DESCRIPTION); ?>"
                    class="regular-text listivo-backend-description listivo-backend-description--small listivo-backend-description--wide"
                    rows="3"
            ><?php echo esc_html(tdf_settings()->getSearchDefaultDescription()); ?></textarea>
        </td>
    </tr>
    </tbody>
</table>

<h2><?php esc_html_e('Search Results Title (H1 tag)', 'listivo-core'); ?></h2>

<table class="form-table">
    <tbody>
    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SEARCH_DEFAULT_TITLE); ?>">
                <?php esc_html_e('Default', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <input
                    id="<?php echo esc_attr(SettingKey::SEARCH_DEFAULT_TITLE); ?>"
                    name="<?php echo esc_attr(SettingKey::SEARCH_DEFAULT_TITLE); ?>"
                    class="regular-text"
                    type="text"
                    value="<?php echo esc_attr(tdf_settings()->getSearchDefaultTitle()); ?>"
            >
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SEARCH_TITLE_FIELDS); ?>">
                <?php esc_html_e('Fields', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                    id="<?php echo esc_attr(SettingKey::SEARCH_TITLE_FIELDS); ?>"
                    name="<?php echo esc_attr(SettingKey::SEARCH_TITLE_FIELDS); ?>[]"
                    class="tdf-selectize tdf-selectize-init"
                    placeholder="<?php esc_attr_e('Search Title Fields', 'listivo-core'); ?>"
                    multiple
            >
                <?php foreach (tdf_settings()->getSearchTitleFields() as $taxonomyField) : ?>
                    <option
                            value="<?php echo esc_attr($taxonomyField->getId()); ?>"
                            selected
                    >
                        <?php echo esc_html($taxonomyField->getName()); ?>
                    </option>
                <?php endforeach; ?>

                <?php foreach (tdf_taxonomy_fields() as $taxonomyField) :
                    if (in_array($taxonomyField->getId(), tdf_settings()->getSearchTitleFieldIds(), true)) {
                        continue;
                    }
                    ?>
                    <option value="<?php echo esc_attr($taxonomyField->getId()); ?>">
                        <?php echo esc_html($taxonomyField->getName()); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <p class="description">
                <?php esc_html_e('Taxonomy fields used to generate the title.', 'listivo-core'); ?>
            </p>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SECOND_SEARCH_TITLE_FIELDS); ?>">
                <?php esc_html_e('Priority Fields', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <select
                    id="<?php echo esc_attr(SettingKey::SECOND_SEARCH_TITLE_FIELDS); ?>"
                    name="<?php echo esc_attr(SettingKey::SECOND_SEARCH_TITLE_FIELDS); ?>[]"
                    class="tdf-selectize tdf-selectize-init"
                    placeholder="<?php esc_attr_e('Search Title Fields', 'listivo-core'); ?>"
                    multiple
            >
                <?php foreach (tdf_settings()->getSearchTitleFields2() as $taxonomyField) : ?>
                    <option
                            value="<?php echo esc_attr($taxonomyField->getId()); ?>"
                            selected
                    >
                        <?php echo esc_html($taxonomyField->getName()); ?>
                    </option>
                <?php endforeach; ?>

                <?php foreach (tdf_taxonomy_fields() as $taxonomyField) :
                    if (in_array($taxonomyField->getId(), tdf_settings()->getSearchTitleFieldIds2(), true)) {
                        continue;
                    }
                    ?>
                    <option value="<?php echo esc_attr($taxonomyField->getId()); ?>">
                        <?php echo esc_html($taxonomyField->getName()); ?>
                    </option>
                <?php endforeach; ?>
            </select>

            <p class="description">
                <?php esc_html_e('These fields will be used first.', 'listivo-core'); ?>
            </p>
        </td>
    </tr>

    <tr>
        <th scope="row">
            <label for="<?php echo esc_attr(SettingKey::SEARCH_OVERRIDE_TITLE_TAG); ?>">
                <?php esc_html_e('Override Title Tag', 'listivo-core'); ?>
            </label>
        </th>

        <td>
            <label for="<?php echo esc_attr(SettingKey::SEARCH_OVERRIDE_TITLE_TAG); ?>">
                <input
                        name="<?php echo esc_attr(SettingKey::SEARCH_OVERRIDE_TITLE_TAG); ?>"
                        id="<?php echo esc_attr(SettingKey::SEARCH_OVERRIDE_TITLE_TAG); ?>"
                        type="checkbox"
                        value="1"
                    <?php if (tdf_settings()->searchOverrideTitleTag()) : ?>
                        checked
                    <?php endif; ?>
                >

                <?php esc_html_e('Override the default html title tag.', 'listivo-core'); ?>
            </label>
        </td>
    </tr>
    </tbody>
</table>

<p class="submit">
    <button class="button button-primary">
        <?php esc_html_e('Save Changes', 'listivo-core'); ?>
    </button>
</p>