<?php

use Tangibledesign\Framework\Core\Settings\SettingKey;
use Tangibledesign\Framework\Models\Page;

?>
<div class="listivo-backend-content">
    <lst-strings>
        <div slot-scope="props">
            <div class="listivo-backend-strings-radios">
                <div class="listivo-backend-strings-radio">
                    <input
                            @click="props.setAll"
                            id="all"
                            type="radio"
                            :checked="props.type === 'all'"
                    >

                    <label for="all"><?php esc_html_e('All', 'listivo-core'); ?></label>
                </div>

                <div class="listivo-backend-strings-radio">
                    <input
                            @click="props.setTranslated"
                            id="translated"
                            type="radio"
                            :checked="props.type === 'translated'"
                    >

                    <label for="translated"><?php esc_html_e('Renamed', 'listivo-core'); ?></label>
                </div>

                <div class="listivo-backend-strings-radio">
                    <input
                            @click="props.setNotTranslated"
                            type="radio"
                            id="not_translated"
                            :checked="props.type === 'not-translated'"
                    >

                    <label for="not_translated"><?php esc_html_e('Not renamed', 'listivo-cor'); ?></label>
                </div>
            </div>

            <p class="submit">
                <button class="button button-primary">
                    <?php esc_html_e('Save Changes', 'listivo-core'); ?>
                </button>
            </p>

            <table class="form-table">
                <tbody>
                <?php foreach (tdf_app('strings') as $lstString) : ?>
                    <tr class="listivo-translate-string">
                        <th scope="row">
                            <label for="<?php echo esc_attr($lstString['key']); ?>">
                                <?php echo esc_html($lstString['name']); ?>
                            </label>
                        </th>

                        <td>
                            <input
                                    id="<?php echo esc_attr($lstString['key']); ?>"
                                    name="strings[<?php echo esc_attr($lstString['key']); ?>]"
                                    class="regular-text"
                                    type="text"
                                    placeholder="<?php esc_attr_e('Translate / rename here', 'listivo-core'); ?>"
                                <?php if ($lstString['value'] !== $lstString['name']) : ?>
                                    value="<?php echo esc_attr($lstString['value']); ?>"
                                <?php endif; ?>
                            >
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </lst-strings>

    <p class="submit">
        <button class="button button-primary">
            <?php esc_html_e('Save Changes', 'listivo-core'); ?>
        </button>
    </p>
</div>