<?php

if (!defined('ABSPATH')) {
	 exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class GVAElement_Listing_Banner extends GVAElement_Base{
	
	const NAME = 'gva_listing_banner';
	const TEMPLATE = 'general/banner';
	const CATEGORY = 'lestin_listing';

	public function get_categories() {
		return self::CATEGORY;
	}

	public function get_name() {
		return self::NAME;
	}

	public function get_title() {
		return esc_html__('Listing Banner', 'lestin-themer');
	}

	public function get_keywords() {
		return [ 'listing', 'banner' ];
	}

	public function get_script_depends() {
		return array();
	}

	public function get_style_depends() {
		return array();
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => __('Content', 'lestin-themer'),
			]
		);
		$this->add_control(
			'style',
			[
				'label'     => __('Style', 'lestin-themer'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default' => 'style-1',
				'options' => [
					'style-1'      => __('Style 01', 'lestin-themer')
				],
			]
	  	);

		$this->add_control(
			'title',
			[
				'label' => __('Title', 'lestin-themer'),
				'type' => Controls_Manager::TEXT,
				'label_block'	=> true,
				'placeholder' => esc_html__('Add your Title', 'lestin-themer'),
				'default' => esc_html__('Switzerland', 'lestin-themer')
			]
		);

		$this->add_control(
			'desc',
			[
				'label' => __('Description', 'lestin-themer'),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Add your Description', 'lestin-themer'),
				'default' => esc_html__('Venezia, Italy', 'lestin-themer')
			]
		);

		$this->add_control(
			'taxonomy',
			[
				'label' => __( 'Style', 'lestin-themer' ),
				'type' => Controls_Manager::SELECT,
				'label_block'	=> true,
				'options' => [
				  'job_listing_region' => esc_html__('Listing Region Taxonomy', 'lestin-themer'),
				  'job_listing_category' => esc_html__('Listing Category Taxonomy', 'lestin-themer'),
				],
				'default' => 'job_listing_region',
			]
		);

		$this->add_control(
			'term_slug',
			[
				'label' => __('Region & Category Slug', 'lestin-themer'),
				'type' => Controls_Manager::TEXT,
				'label_block'	=> true,
				'placeholder' => esc_html__('Term slug', 'lestin-themer'),
				'default' => ''
			]
		);
		$this->add_control(
			'image',
			[
				'label' 		=> __('Image', 'lestin-themer'),
				'type' 		=> Controls_Manager::TEXT,
				'default'    => [
					 'url' => GAVIAS_LESTIN_PLUGIN_URL . 'elementor/assets/images/image-banner.jpg',
				],
				'type'       => Controls_Manager::MEDIA,
				'show_label' => false,
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label' => __('Height', 'lestin-themer'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
				  'px' => [
					 'min' => 100,
					 'max' => 1000,
				  ],
				],
				'default' => [
				  'size'  => 270
				],
				'condition' => [
				  'style' => ['style-1']
				],
				'selectors' => [
				  '{{WRAPPER}} .banner-one__wrap' => 'min-height: {{SIZE}}{{UNIT}};',
				  '{{WRAPPER}} .banner-two__wrap' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		); 

		$this->add_control(
			'link_custom',
			[
				'label' => __('Link Custom', 'lestin-themer'),
				'type' => Controls_Manager::TEXT,
				'label_block'	=> true,
				'default' => ''
			]
		);
		$this->add_control(
			'image_size',
			[
				'label'     => __('Image Size', 'lestin-themer'),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options'   => $this->get_thumbnail_size(),
				'default'   => 'full'
			]
		);
		$this->add_control(
			'bg_overlay',
			[
				'label' => __('Overlay Background', 'lestin-themer'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
				  '{{WRAPPER}} .banner-one__image:after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'show_number_content',
			[
				'label'   => __('Show number content', 'lestin-themer'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		 );
		$this->add_control(
			'show_number_text',
			[
				'label'   => __('Text Prefix', 'lestin-themer'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('listings', 'lestin-themer'),
				'condition' => [
				  'show_number_content' => ['yes']
				],
			]
		 );
		$this->add_control(
			'show_number_one_text',
			[
				'label'   => __('Text Prefix One Item', 'lestin-themer'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('listing', 'lestin-themer'),
				'condition' => [
				  'show_number_content' => ['yes']
				],
			]
		 );
		$this->add_control(
			'item_active',
			[
				'label'   => __('Active', 'lestin-themer'),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'no'
			]
		 );
		$this->end_controls_section();


		$this->start_controls_section(
			'section_style_content',
			[
				'label' => __('Content', 'lestin-themer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'heading_title',
			[
				'label' => __('Title', 'lestin-themer'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		  $this->add_control(
			 'title_color',
			 [
				'label' => __('Color', 'lestin-themer'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
				  '{{WRAPPER}} .banner-one__title' => 'color: {{VALUE}};',
				  '{{WRAPPER}} .banner-two__title' => 'color: {{VALUE}};',
				],
			 ]
		  );

		  $this->add_group_control(
			 Group_Control_Typography::get_type(),
			 [
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .banner-one__title, {{WRAPPER}} .banner-two__title',
			 ]
		  );

		  	$this->add_control(
			'heading_desc',
			[
				'label' => __('Description', 'lestin-themer'),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		  $this->add_control(
			 'desc_color',
			 [
				'label' => __('Color', 'lestin-themer'),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
				  '{{WRAPPER}} .banner-one__desc' => 'color: {{VALUE}};',
				  '{{WRAPPER}} .banner-two__desc' => 'color: {{VALUE}};',
				],
			 ]
		  );

		  $this->add_group_control(
			 Group_Control_Typography::get_type(),
			 [
				'name' => 'desctypography',
				'selector' => '{{WRAPPER}} .banner-one__desc, {{WRAPPER}} .banner-two__desc',
			 ]
		  );


		  $this->end_controls_section();
	 }

	 protected function render() {
		$settings = $this->get_settings_for_display();
		printf('<div class="gva-element-%s gva-element">', $this->get_name() );
			include $this->get_template( self::TEMPLATE . '.php');
		print '</div>';
	 }

}

$widgets_manager->register(new GVAElement_Listing_Banner());
