<?php
if (!defined('ABSPATH')) { exit; }

use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;

class GVAElement_Listing_Item_Tagline extends GVAElement_Base{
    
   const NAME = 'gva_lt_item_tagline';
   const TEMPLATE = 'listing/item-tagline';
   const CATEGORY = 'lestin_listing';

   public function get_categories() {
      return array(self::CATEGORY);
   }

   public function get_name() {
      return self::NAME;
   }

   public function get_title() {
      return __('Listing Item Tagline', 'lestin-themer');
   }

   public function get_keywords() {
      return [ 'listing', 'item', 'tagline' ];
   }

   protected function register_controls() {
      //--
      $this->start_controls_section(
         self::NAME . '_content',
         [
            'label' => __('Content', 'lestin-themer'),
         ]
      );

      $this->add_responsive_control(
         'text_color_res',
         [ 
            'label' => __( 'Text Color', 'lestin-themer' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .gva-listing-tagline .content-inner' => 'color: {{VALUE}};',
            ],
         ] 
      );

      $this->add_group_control(
         Group_Control_Typography::get_type(),
         [
            'name' => 'typography_text',
            'selector' => '{{WRAPPER}} .gva-listing-tagline .content-inner',
         ]
      );

      $this->end_controls_section();

   }

   protected function render(){
      parent::render();

      $settings = $this->get_settings_for_display();
      include $this->get_template(self::TEMPLATE . '.php');
   }
}

$widgets_manager->register(new GVAElement_Listing_Item_Tagline());
