<?php
if (!defined('ABSPATH')) { exit; }

use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;

class GVAElement_Listing_Item_Video extends GVAElement_Base{
    
   const NAME = 'gva_lt_item_video';
   const TEMPLATE = 'listing/item-video';
   const CATEGORY = 'lestin_listing';

   public function get_categories() {
      return array(self::CATEGORY);
   }

   public function get_name() {
      return self::NAME;
   }

   public function get_title() {
      return __('Listing Item Video', 'lestin-themer');
   }

   public function get_keywords() {
      return [ 'listing', 'item', 'video' ];
   }

   protected function register_controls() {
      //--
      $this->start_controls_section(
         self::NAME . '_content',
         [
            'label' => __('Content', 'lestin-themer'),
         ]
      );

      $this->add_control(
         'title',
         [
            'label'     => __( 'Title', 'lestin-themer' ),
            'type'      => Controls_Manager::TEXT,
            'default'   => esc_html__( 'Video', 'lestin-themer' )
         ]
      );
      $this->add_control(
         'heading_style_title',
         [
            'label' => esc_html__( 'Style Title Text', 'lestin-themer' ),
            'type' => Controls_Manager::HEADING
         ]
      );
      $this->add_control(
         'text_color',
         [
            'label' => __( 'Text Color', 'lestin-themer' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
               '{{WRAPPER}} .element-item-listing .block-title' => 'color: {{VALUE}};',
            ],
         ]
      );

      $this->add_group_control(
         Group_Control_Typography::get_type(),
         [
            'name' => 'typography_text',
            'selector' => '{{WRAPPER}} .element-item-listing .block-title',
         ]
      );

      $this->end_controls_section();

   }

   protected function render(){
      parent::render();

      $settings = $this->get_settings_for_display();
      include $this->get_template(self::TEMPLATE . '.php');
   }
}

$widgets_manager->register(new GVAElement_Listing_Item_Video());
