<?php
if(!defined('ABSPATH')){ exit; }

use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class GVAElement_Listing_Search_Form extends GVAElement_Base {
   const NAME = 'gva-listing-search-form';
   const TEMPLATE = 'listing/search-form';
   const CATEGORY = 'lestin_listing';

   public function get_name() {
      return self::NAME;
   }

   public function get_categories() {
      return array(self::CATEGORY);
   }

	public function get_title() {
		return __( 'Listing - Search Form', 'lestin-themer' );
	}

	public function get_keywords() {
		return [ 'listings', 'search', 'form', 'content' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'lestin-themer' ),
			]
		);
      $this->add_control(
         'style',
         [
            'label' => __( 'Style', 'lestin-themer' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
              'style-1' => esc_html__('Style 01', 'lestin-themer'),
              'style-2' => esc_html__('Style 02', 'lestin-themer'),
              'style-3' => esc_html__('Style 03', 'lestin-themer')
            ],
            'default' => 'style-1',
         ]
      );
      $this->add_control(
         'url_listings_page',
         [
            'label' => esc_html__( 'Url Listings Page', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::TEXT,
            'placeholder' => esc_html__('Url Listings Page Results', 'lestin-themer'),
            'label_block' => true 
         ]
      );
		$this->add_control(
         'search_keyword',
         [
            'label' => esc_html__( 'Enable search keyword', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',
         ]
      );
      $this->add_control(
         'search_category',
         [
            'label' => esc_html__( 'Enable search category', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',
         ]
      );
      $this->add_control(
         'search_regions',
         [
            'label' => esc_html__( 'Enable search region', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::SWITCHER,
            'default' => 'no',
         ]
      );
      $this->add_control(
         'search_location',
         [
            'label' => esc_html__( 'Enable search location', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::SWITCHER,
            'default' => 'yes',
         ]
      );
      $this->add_control(
         'placeholder_keyword',
         [
            'label' => esc_html__( 'Placeholder keyword input', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('What are you looking for?', 'lestin-themer'),
            'label_block' => true 
         ]
      );
      $this->add_control(
         'placeholder_location',
         [
            'label' => esc_html__( 'Placeholder location input', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('Location (e.g. New York)', 'lestin-themer'),
            'label_block' => true 
         ]
      );
      $this->add_control(
         'placeholder_category',
         [
            'label' => esc_html__( 'Placeholder category input', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('All Categories', 'lestin-themer'),
            'label_block' => true 
         ]
      );
      $this->add_control(
         'placeholder_region',
         [
            'label' => esc_html__( 'Placeholder region input', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('All regions', 'lestin-themer'),
            'label_block' => true 
         ]
      );
      $this->add_control(
         'btn_text',
         [
            'label' => esc_html__( 'Text of button search', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('Search', 'lestin-themer'),
            'label_block' => true 
         ]
      );
      $this->add_control(
         'btn_submit_width',
         [
            'label' => esc_html__( 'Width submit button', 'lestin-themer' ),
            'type' => Elementor\Controls_Manager::SLIDER,
            'default' => [
               'size' => 190,
            ],
            'range' => [
               'px' => [
                  'min' => 50,
                  'max' => 350,
               ],
            ],
            'selectors' => [
               '{{WRAPPER}} .gsc-call-to-action .content-inner .cta-content' => 'max-width: {{SIZE}}{{UNIT}};',
            ],
         ]
      );
		$this->end_controls_section();

		$this->start_controls_section(
			'section_box_style',
			[
				'label' => __( 'Logo Styling', 'lestin-themer' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'logo_padding',
			[
				'label' => __( 'Padding', 'lestin-themer' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .gsc-logo .site-branding-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'logo_margin',
			[
				'label' => __( 'Margin', 'lestin-themer' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .gsc-logo .site-branding-logo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
         Group_Control_Border::get_type(),
         [
            'name'      => 'logo_border',
            'selector'  => '{{WRAPPER}} .gsc-logo .site-branding-logo',
            'separator' => 'before',
         ]
       );

       $this->add_control(
         'image_border_radius',
         [
            'label'      => __('Border Radius', 'lestin-themer'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .gsc-logo .site-branding-logo' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
         ]
       );
		$this->end_controls_section();

	}

	protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="gva-element-%s gva-element">', $this->get_name() );
         include $this->get_template(self::TEMPLATE . '.php');
      print '</div>';
	}
}

$widgets_manager->register( new GVAElement_Listing_Search_Form );
