<?php
   use Elementor\Icons_Manager;

   if (!defined('ABSPATH')){ exit; }
   global $lestin_post;
   if (!$lestin_post){ return; }
   if ($lestin_post->post_type != 'job_listing'){ return;}
   
   $has_icon = ! empty( $settings['selected_icon']['value']);

   $post_id = $lestin_post->ID;
   $key = '_lt_' . $settings['key'];

   if($settings['key'] == 'location') $key = '_job_location';
   $value = get_post_meta($post_id, $key, true);
?>

<div class="gva-listing-info lt-info-<?php echo esc_attr($settings['key']) ?>">
   <?php if( $value ){ ?>
      <div class="content-inner">
         <?php 
            echo '<span class="info-value">';
               switch ($settings['key']) {
                  case 'phone':
                     echo '<a href="tel:' . esc_attr($value) . '">';
                        if($has_icon) Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                        echo '<span>' . esc_html($value) . '</span>';
                     echo '</a>';
                     break;
                  case 'email':
                     echo '<a href="mailto:' . esc_attr($value) . '">';
                        if($has_icon) Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                        echo '<span>' . esc_html($value) . '</span>';
                     echo '</a>';
                     break;
                  case 'website':
                     echo '<a target="_blank" href="' . esc_url($value) . '">';
                        if($has_icon) Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                        echo '<span>' . esc_html($value) . '</span>';
                     echo '</a>';
                     break;
                  case 'location':
                     if($has_icon) Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                     echo '<span>' . esc_html($value) . '</span>';
                     break;
                  case 'whatsapp':
                     echo '<a href="https://wa.me/'.esc_html($value).'">';
                        if($has_icon) Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                        echo '<span>' . esc_html($value) . '</span>';
                     echo '</a>';
                     break;
                  default:
                     if($has_icon) Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                     echo '<span>' . esc_html($value) . '</span>';
                  break;
                  
               }
               
         ?>
      </div>
   <?php } ?>
</div>

