<?php
   if (!defined('ABSPATH')){ exit; }
   global $lestin_post;
   if (!$lestin_post){ return; }
   if ($lestin_post->post_type != 'job_listing'){ return;}
   
   $post_id = $lestin_post->ID;
?>

<div class="listing-detail-rating">
   <div class="content-wrap">
      <?php 
         if($settings['check_open'] == 'yes'){
            $status = Lestin_Lising_Theme::instance()->check_open($post_id);
            if($status['check'] == 'open'){
               echo '<div class="open-check ' . esc_html($status['check']) . '">';
                  echo '<i class="fa-solid fa-circle-check"></i>';
                  echo esc_html__('Open Now', 'lestin-themer');
               echo '</div>';
            }
            if($status['check'] == 'closed'){
                echo '<div class="open-check ' . esc_html($status['check']) . '">';
                  echo '<i class="fa-solid fa-circle-xmark"></i>';
                  echo esc_html__('Closed Now', 'lestin-themer');
               echo '</div>';
            }
         }
      ?>

      <!-- Reviews Addon -->
      <?php 
         if( class_exists('Lestin_Listing_Comment') ){
            $count_reviews = Lestin_Listing_Comment::instance()->total_reviews($post_id, 0, true);
            $review_avg = get_post_meta( $post_id, 'lt_reviews_average', true );
            $review_text = $count_reviews == 1 ? esc_html__('review', 'lestin-themer') : esc_html__('reviews', 'lestin-themer');

            if( !empty($review_avg) ){
               echo '<div class="gva-listing-rating">';
                  echo '<div class="review-avg-content">';
                     echo '<div class="review-star">';
                        echo Lestin_Listing_Comment::instance()->show_star_by_avg(round($review_avg, 2)); 
                        echo '<span class="review-text">';
                           echo (round($review_avg, 2) . ' ' . esc_html__( 'by', 'lestin-themer' ) . ' ' . esc_html($count_reviews) . ' ' . $review_text);
                        echo '</span>';  
                     echo '</div>';
                  echo '</div>';
               echo '</div>';
            } 
         } 
      ?>
      <!-- End Reviews Addon -->
   </div>
</div>

