<?php
if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly
}

class Lestin_LT_Fields_Model {

   private static $instance = null;
   public static function instance() {
      if ( is_null( self::$instance ) ) {
         self::$instance = new self();
      }
      return self::$instance;
   }

   public function default_fields(){
      $fields = array();

      $fields['featured'] = array(
         'label'        => esc_html__('Featured Listing', 'lestin-themer'),
         'type'         => 'checkbox',
         'required'     => false,
         'priority'     => 1.1,
         'description'  => esc_html__('Featured Listing will be display to top during searches and styling featured.', 'lestin-themer')
      );
      $fields['lt_claimed'] = array(
         'label'        => esc_html__('Claimed', 'lestin-themer'),
         'type'         => 'checkbox',
         'required'     => false,
         'priority'     => 1.2,
         'description'  => esc_html__(' The owner has been verified.', 'lestin-themer')
      );
      $fields['lt_tagline'] = array(
         'label' => esc_html__('Tagline', 'lestin-themer'),
         'type' => 'custom-text',
         'required' => false,
         'placeholder' => esc_html__('tagline', 'lestin-themer'),
         'priority'    => 1.3,
         'default'     => '',
         'group'       => 'general'
      );
      $fields['job_expires'] = array(
         'label' => esc_html__('Listing Expiry Date', 'lestin-themer'),
         'type' => 'custom_date',
         'required' => false,
         'placeholder' => esc_html__('Listing Expiry Date', 'lestin-themer'),
         'priority'    => 1.4
      );

      // Category and Amenities
      $fields['lt_heading_2'] = array(
         'label' => esc_html__( 'Listing Category and Amenities', 'lestin-themer' ),
         'type'        => 'custom-heading',
         'priority'     => 2.1,
         'required' => false,
         'heading_under' => true
      );
      $fields['lt_category'] = array(
         'label'       => esc_html__( 'Listing Category', 'lestin-themer' ),
         'type'        => 'term-checklist',
         'taxonomy'    => 'job_listing_category',
         'priority'    => 2.3,
         'required'    => false, 
         'placeholder' => esc_html__( 'Add Category', 'lestin-themer' ),
         'group'       => 'general'
      );
      $fields['lt_amenities'] = array(
         'type' => 'term-checklist',
         'default' => '',
         'taxonomy' => 'job_listing_amenity',
         'priority'     => 2.4,
         'required' => false, 
         'placeholder' => esc_html__( 'Add Amenity', 'lestin-themer' ),
         'label' => esc_html__( 'Listing Amenity', 'lestin-themer' ),
         'group'       => 'general'
      );
      //Video 
      $fields['lt_heading_3'] = array(
         'label' => esc_html__( 'Listing Media', 'lestin-themer' ),
         'type'        => 'custom-heading',
         'priority'     => 3.0,
         'required' => false,
         'heading_under' => true
      );
      $fields['lt_logo_image'] = array(
         'label'        => esc_html__( 'Listing Logo', 'lestin-themer' ),
         'priority'     => 3.1,
         'required'     => false,
         'type'         => 'file',
         'ajax'         => true,
         'placeholder'  => '',
         'multiple'     => false,
         'allow_types'  => array(
            'jpg|jpeg|jpe',
            'jpeg',
            'gif',
            'png',
         ),
         'group'       => 'media'
      );
      $fields['lt_gallery_images'] = array(
         'label' => esc_html__( 'Listing Gallery', 'lestin-themer' ),
         'priority' => 3.2,
         'required' => false,
         'type' => 'file',
         'ajax' => true,
         'placeholder' => '',
         'multiple'    => true,
         'allow_types' => array(
            'jpg|jpeg|jpe',
            'jpeg',
            'gif',
            'png',
         ),
         'description'     => esc_html__('The first image will be featured image of Listing'),
         'group'       => 'media'
      );
      $fields['lt_banner_image'] = array(
         'label' => esc_html__( 'Listing Banner Image', 'lestin-themer' ),
         'priority'        => 3.3,
         'required'        => false,
         'type'            => 'file',
         'ajax'            => true,
         'placeholder'     => '',
         'multiple'        => false,
         'description'     => esc_html__('Optional for Booking Type = Banner'),
         'allow_types'     => array(
            'jpg|jpeg|jpe',
            'jpeg',
            'gif',
            'png',
         ),
         'group'           => 'media'
      );

      $fields['lt_video'] = array(
         'label'        => esc_html__( 'Listing Video', 'lestin-themer' ),
         'type'         => 'custom-text',
         'priority'     => 3.4,
         'required'     => false, 
         'placeholder' => esc_html__( 'Listing Video Link', 'lestin-themer' ),
         'group'        => 'media'
      );
      //Location Information
      $fields['lt_heading_4'] = array(
         'label' => esc_html__( 'Listing Location Information', 'lestin-themer' ),
         'type'        => 'custom-heading',
         'priority'     => 4.0,
         'required' => false,
         'heading_under' => false
      );
      $fields['lt_regions'] = array(
         'label'        => esc_html__( 'Listing Region', 'lestin-themer' ),
         'type'         => 'term-select',
         'taxonomy'     => 'job_listing_region',
         'priority'     => 4.1,
         'required'     => true, 
         'placeholder'  => esc_html__( 'Select Region', 'lestin-themer' ),
         'group'        => 'location'
      );
      $fields['job_location'] = array(
         'label'        => esc_html__( 'Location', 'lestin-themer' ),
         'type'         => 'custom-text',
         'priority'     => 4.2,
         'required'     => false, 
         'placeholder'  => esc_html__( 'e.g 34 Wigmore Street, London', 'lestin-themer' ),
         'description'  => esc_html__( 'Leave this blank if the location is not important.', 'lestin-themer' ),
         'classes'      => array('id_job_listing_location_text'),
         'group'        => 'location'
      );
      $fields['lt_map'] = array(
         'label'       => esc_html__( 'Location Map', 'lestin-themer' ),
         'type' => 'custom-map',
         'priority' => 4.2,
         'required'  => false, 
         'placeholder' => esc_html__( 'e.g 34 Wigmore Street, London', 'lestin-themer' ),
         'group'        => 'location'
      );
      //Business Information
      $fields['lt_heading_5'] = array(
         'label' => esc_html__( 'Listing Business Information', 'lestin-themer' ),
         'type'          => 'custom-heading',
         'priority'      => 5.0,
         'required' => false,
         'heading_under' => false
      );
      $fields['lt_email'] = array(
         'label'        => esc_html__('Email', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 5.1,
         'placeholder'  => esc_html__( 'e.g: contact@example.com', 'lestin-themer' ),
         'group'        => 'business'
      );
      $fields['lt_phone'] = array(
         'label'        => esc_html__('Phone', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 5.2,
         'placeholder'  => esc_html__( 'e.g: +84 123456789', 'lestin-themer' ),
         'group'        => 'business'
      );
      $fields['lt_website'] = array(
         'label'        => esc_html__('Website', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 5.3,
         'placeholder'  => esc_html__( 'e.g: https://example.com', 'lestin-themer' ),
         'group'        => 'business'
      );
      $fields['lt_address'] = array(
         'label'        => esc_html__('Address', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 5.4,
         'placeholder'  => esc_html__( 'e.g: 68 Sunrise Oakdale, New York USA', 'lestin-themer' ),
         'group'        => 'business'
      );
      $fields['lt_whatsapp'] = array(
         'label'        => esc_html__('WhatsApp', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 5.5,
         'group'        => 'business'
      );
      // Price Range
      $lt_currency = lestin_themer_get_theme_option('lt_currency_symbol', '$');
      $fields['lt_heading_6'] = array(
         'label' => esc_html__( 'Listing Information', 'lestin-themer' ),
         'type'          => 'custom-heading',
         'priority'      => 6.0,
         'required'     => false,
         'heading_under' => false
      );
      $fields['lt_price_range'] = array(
         'label'     => esc_html__('Price Range', 'lestin-themer'),
         'type'      => 'select',
         'required'  => false,
         'priority'  => 6.1,
         'options' => array(
            'inexpensive'        => $lt_currency . esc_html__(' - Inexpensive', 'lestin-themer'),
            'moderate'           => $lt_currency . $lt_currency . esc_html__(' - Moderate', 'lestin-themer'),
            'pricey'             => $lt_currency . $lt_currency . $lt_currency . esc_html__(' - Pricey', 'lestin-themer'),
            'ultra-high'         => $lt_currency . $lt_currency . $lt_currency . $lt_currency . esc_html__(' - Ultra High', 'lestin-themer')
         ),
         'group'     => 'information'
      );

      $fields['lt_price_from'] = array(
         'label'        => esc_html__('Price From', 'lestin-themer') . '(' . $lt_currency . ')',
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 6.2,
         'placeholder'  => esc_html__( 'e.g: 80', 'lestin-themer' ),
         'group'        => 'information'
      );
      $fields['lt_price_to'] = array(
         'label'        => esc_html__('Price To', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 6.3,
         'placeholder'  => esc_html__( 'e.g: 150', 'lestin-themer' ),
         'group'        => 'information'
      );
      $fields['lt_duration'] = array(
         'label'        => esc_html__('Duration', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 6.4,
         'placeholder'  => esc_html__( 'e.g: 10 days', 'lestin-themer' ),
         'group'        => 'information'
      );
      $fields['lt_language'] = array(
         'label'        => esc_html__('Language', 'lestin-themer'),
         'type'         => 'custom-text',
         'required'     => false,
         'priority'     => 6.4,
         'placeholder'  => esc_html__( 'e.g: English', 'lestin-themer' ),
         'group'        => 'information'
      );

      // Socials Link
      $fields['lt_heading_7'] = array(
         'label'           => esc_html__( 'Listing Socials', 'lestin-themer' ),
         'type'            => 'custom-heading',
         'priority'        => 7.0,
         'required'        => false,
         'heading_under'   => false
      );
      $fields['lt_socials_media'] = array(
         'label'     => esc_html__("Social Media", 'lestin-themer'),
         'type'      => 'custom-socials',
         'required'  => false,
         'priority'  => 7.1,
          'group'    => 'social'
      );

      // Booking Type
      $fields['lt_heading_8'] = array(
         'label'           => esc_html__( 'Listing Booking Type', 'lestin-themer' ),
         'type'            => 'custom-heading',
         'priority'        => 8.0,
         'required'        => false,
         'heading_under'   => false
      );
      $fields['lt_booking_type'] = array(
         'label'     => esc_html__("Listing Booking Type", 'lestin-themer'),
         'type'      => 'custom-booking-type',
         'required'  => false,
         'priority'  => 8.1,
         'group'    => 'booking_type'
      );
      
      // Business Hours
      $fields['lt_heading_9'] = array(
         'label'           => esc_html__( 'Business Hours', 'lestin-themer' ),
         'type'            => 'custom-heading',
         'priority'        => 9.0,
         'required'        => false,
         'heading_under'   => false
      );
      $fields['lt_hours'] = array(
         'label'     => esc_html__("Business Hours", 'lestin-themer'),
         'type'      => 'custom-hours',
         'required'  => false,
         'priority'  => 9.1,
         'group'    => 'hours'
      );
      // Business Hours
      $fields['lt_heading_10'] = array(
         'label'           => esc_html__( 'Additional Info', 'lestin-themer' ),
         'type'            => 'custom-heading',
         'priority'        => 10.0,
         'required'        => false,
         'heading_under'   => false 
      ); 
      $fields['lt_additional_info'] = array(
         'label'     => esc_html__("Additional Info", 'lestin-themer'),
         'type'      => 'custom-additional-info',
         'required'  => false,
         'priority'  => 10.1,
         'group'    => 'additional'
      );

     // Custom Fields
      $fields['lt_heading_10'] = array(
         'label'           => esc_html__( 'Custom Fields', 'lestin-themer' ),
         'type'            => 'custom-heading',
         'priority'        => 11.0,
         'required'        => false,
         'heading_under'   => false 
      ); 
      
      return $fields;
   }

   public function listing_fields($admin = false){
      $fields = $this->default_fields();
      
      // Remove Field Heading on Submit Form
      if(!$admin){
         foreach ($fields as $key => $field) {
            if( $field['type'] == 'custom-heading'){
               unset($fields[$key]);
            }
         }
      }

      $fields_option = $this->listing_fields_option();
      //print"<pre>"; print_r($fields_option);
      if($fields_option){
         $priority_custom_fields = 11;
         foreach ($fields_option as $key => $field) {

            if(isset($fields[$key]) && $fields[$key]){
               $fields[$key]['type_field'] = 'available';
               $field['type_field'] = 'available';
            }

            if($field['type_field'] == 'available'){
               if($field['disable']){
                  unset($fields[$key]);
               }else{
                  $fields[$key]['label'] = $field['label'];
                  $fields[$key]['description'] = $field['description'];
                  $fields[$key]['placeholder'] = $field['placeholder'];
                  $fields[$key]['default'] = $field['default'];
                  $fields[$key]['group'] = $field['group'];
                  if(!$admin){
                     $fields[$key]['priority'] = $field['priority'];
                  }
               }
            }else{
               $priority_custom_fields = $priority_custom_fields + 0.1;
               $fields[$key] = $field;
               $fields[$key]['priority'] = $priority_custom_fields;
            }
         }
      }

      return $fields;
   }

   public function listing_fields_option(){
      $fields = array();
      $fields_data = get_option('gva_listing_fields');
      if(!empty($fields_data)){
         foreach ($fields_data as $key => $field){
            $field_key = isset($field['key']) ? $field['key'] : '';
            $fields[$field_key] = array(
               'label'        => isset($field['label']) ? $field['label'] : '',
               'key'          => isset($field['key']) ? $field['key'] : '',
               'description'  => isset($field['description']) ? $field['description'] : '',
               'placeholder'  => isset($field['placeholder']) ? $field['placeholder'] : '',
               'priority'     => isset($field['priority']) ? $field['priority'] : '90',
               'type'         => isset($field['type']) ? $field['type'] : '',
               'type_field'   => isset($field['type_field']) ? $field['type_field'] : 'custom',
               'default'      => isset($field['default']) ? $field['default'] : '',
               'disable'      => isset($field['disable']) ? $field['disable'] : '',
               'required'     => isset($field['required']) ? $field['required'] : '',
               'group'        => isset($field['group']) ? $field['group'] : 'other'
            );
         }
      }
      return $fields;
   }

   public function listing_fields_groups(){
      return array(
         'general'         => esc_html__('General', 'lestin-themer'),
         'media'           => esc_html__('Media', 'lestin-themer'),
         'location'        => esc_html__('Location', 'lestin-themer'),
         'business'        => esc_html__('Business Information', 'lestin-themer'),
         'information'     => esc_html__('Listing Information', 'lestin-themer'),
         'social'          => esc_html__('Social', 'lestin-themer'),
         'hours'           => esc_html__('Business Hours', 'lestin-themer'),
         'booking_type'    => esc_html__('Booking Type', 'lestin-themer'),
         'additional'      => esc_html__('Additional Info', 'lestin-themer'),
         'other'           => esc_html__('Other', 'lestin-themer')
      );
   }

   
   public function select_hours($fvalue = ''){
      $lower = 0; $upper = 86400; $step = 1800;
      $format = get_option( 'time_format' );
      $html = '';
      $times = array();
      $html .= '<option value="">' . esc_html__( 'From', 'lestin-themer' ) . '</option>';
      
      foreach(range( $lower, $upper, $step ) as $increment){
         $value = gmdate('H:i', $increment);
         $display = gmdate($format, $increment);
         if( !isset($times[$value]) ){
            $html .= '<option value="' . $value . '"'.trim($value == $fvalue ? ' selected="selected"' : '') . '>' . esc_html($display) . '</option>';
         }
         $times[$value] = $display; 
      }

      return $html;
   }
}

