<?php
class Lestin_Filter{

	public function __construct(){
      add_filter('job_manager_get_listings_args', array($this, 'job_manager_get_listings_args'), 10, 1);

		add_filter( 'job_manager_get_listings', array($this,'filter_fields_query_args'), 10, 2 );
		add_filter( 'posts_where', array($this, 'title_filter'), 10, 2 );
		add_filter( 'job_listing_searchable_meta_keys', array($this, 'job_listing_searchable_meta_keys'), 10, 2 );
	
		add_action( 'wp_ajax_lestin_get_listings_map', [ $this, 'get_listings_map' ] ); 
      add_action( 'wp_ajax_nopriv_lestin_get_listings_map', [ $this, 'get_listings_map' ] );
	}

	function job_listing_searchable_meta_keys(){
		return array();
	}

	function title_filter( $where, $wp_query ){
	   global $wpdb;
	    // 2. pull the custom query in here:
	   if ( $search_term = $wp_query->get( 'search_prod_title' ) ) {
	      $where .= ' AND ' . $wpdb->posts . '.post_title LIKE \'%' . esc_sql( like_escape( $search_term ) ) . '%\'';
	   }
	   return $where;
	}

   function job_manager_get_listings_args($args){
      if ( isset($_POST['form_data']) ){
         parse_str( $_POST['form_data'], $form_data );
         $args = wp_parse_args( $form_data, $args);

          // search categories array
         $search_categories = isset( $form_data['search_categories'] ) ? wp_unslash( $form_data['search_categories'] ) : ''; 
         if ( is_array( $search_categories ) ) {
            $args['search_categories'] = array_filter( array_map( 'sanitize_text_field', array_map( 'stripslashes', $search_categories ) ) );
         } else {
            $args['search_categories'] = array_filter( [ sanitize_text_field( wp_unslash( $search_categories ) ) ] );
         }
      }
      return $args;
   }

	function filter_fields_query_args( $query_args, $args ){
		// if ( isset($_POST['form_data']) ){
		// 	parse_str( $_POST['form_data'], $form_data );

         $form_data = $args;

			// If this is set, we are filtering by fields
			$tax_querys = array();

			//Filter by title
			if(get_option('lt_search_keywords_type') == 'only_title'){
				if ( isset($form_data['search_keywords'] ) && !empty( $form_data['search_keywords'] ) ) {
					$search_title = $form_data['search_keywords'];
					$query_args['search_prod_title'] = trim($search_title);
				}
			}

			//Filter by amenities
			if ( isset($form_data['filter_listing_amenity'] ) && !empty( $form_data['filter_listing_amenity'] ) ) {
				$amenities_data =  $form_data['filter_listing_amenity'];
				$query_args['tax_query'][] = array(
					'taxonomy'         => 'job_listing_amenity',
					'field'            => 'term_id',
					'terms'            => $amenities_data,
					'operator'         => 'IN'
				);
			}

			//Filter by regions
			if ( isset($form_data['search_region'] ) && !empty( $form_data['search_region'] ) ) {
				$region_data =  $form_data['search_region'];
				if(is_array($region_data) && isset($region_data[0])){
					$region_data = $region_data[0];
				}
				if($region_data){
					$query_args['tax_query'][] = array(
						'taxonomy'         => 'job_listing_region',
						'field'            => 'term_id',
						'terms'            => $region_data,
						'operator'         => 'IN'
					);
					$term = get_term($region_data, 'job_listing_region');
					$term_childs = get_term_children($term->term_id, 'job_listing_region');
					if($term_childs){
						foreach ($term_childs as $term) {
							if ( isset($term->term_id) && $term->term_id ) {
								$query_args['tax_query'][] = array(
									'taxonomy'         => 'job_listing_region',
									'field'            => 'term_id',
									'terms'            => $term->term_id,
									'operator'         => 'IN'
								);
							}
						}
					}
				}
			}

			//Filter by type
			if ( isset($form_data['lt_filter_job_type'] ) && !empty( $form_data['lt_filter_job_type']) ) {
				$type_data = array_filter($form_data['lt_filter_job_type']);
				if( count($type_data) ){
					$query_args['tax_query'][] = array(
						'taxonomy'         => 'job_listing_type',
						'field'            => 'slug',
						'terms'            => $type_data,
						'operator'         => 'IN'
					);
				}
			}

			//Filter by tags
			if (isset($form_data['lt_filter_tag']) && $form_data['lt_filter_tag']) {
				$query_args['tax_query'][] = array(
					'taxonomy'         => 'job_listing_tag',
					'field'            => 'slug',
					'terms'            => $form_data['lt_filter_tag'],
					'operator'         => 'IN'
				);
			}

			// Join tax query
			$tax_querys = $query_args['tax_query'];
			$query_args['tax_query'] = array();

			if( $tax_querys && is_array($tax_querys) ){
				if ( count($tax_querys) > 1 ) {
					$query_args['tax_query']['relation'] = 'AND';
				}
				foreach ($tax_querys as $tax_query) {
					$query_args['tax_query'][] = $tax_query;
				}
			}

			//Filter by Location
			if ( isset($form_data['lt_filter_location_value']) && !empty( $form_data['lt_filter_location_value']) ) {
				$location_data =  $form_data['lt_filter_location_value'];
				$lt_filter_distance = (isset($form_data['lt_filter_distance']) && $form_data['lt_filter_distance']) ? $form_data['lt_filter_distance'] : 120;
				
				//echo $lt_filter_distance;
				//$location_data = '40.7127281,-74.0060152';
				$use_miles = false; // use KM

				$distance_unit = lestin_themer_get_theme_option('lt_distance_unit', 'km');
				if($distance_unit = 'km'){
					$use_miles = false;
				}else{
					$use_miles = true;
				}

				if(!empty($location_data)){
					$lat_lng = explode(',', $location_data);
					$lat = isset($lat_lng[0]) && $lat_lng[0] ? $lat_lng[0] : '';
					$lng = isset($lat_lng[1]) && $lat_lng[1] ? $lat_lng[1] : '';

					$ids = $this->get_nearby_locations($lat, $lng, -1, $lt_filter_distance, 99999, 'job_listing', $use_miles);
					if(count($ids) == 0){
						$ids[0] = 0;
					}
					$query_args['post__in'] = $ids;

				}else{
					if ( isset($form_data['_search_location']) && !empty($form_data['_search_location']) ) {
						$location_meta_keys = [ 'geolocation_formatted_address', '_job_location', 'geolocation_state_long' ];
						$location_search    = [ 'relation' => 'OR' ];
						foreach ( $location_meta_keys as $meta_key ) {
							$location_search[] = [
								'key'     => $meta_key,
								'value'   => $form_data['_search_location'],
								'compare' => 'like'
							];
						}
						$query_args['meta_query'][] = $location_search;
					}
				}
			}

			if ( isset($form_data['lt_filter_price_range']) && !empty( $form_data['lt_filter_price_range']) ) {
				$price_range = $form_data['lt_filter_price_range'];
				$query_args['meta_query'][] = array(
					'key'     => '_lt_price_range',
					'value'   => $price_range,
					'compare' => 'like'
				);
			}

			// ======== Order ========
			if ( isset($form_data['lt_results_sorting']) && !empty($form_data['lt_results_sorting']) ) {
				$sorting = $form_data['lt_results_sorting'];
				switch ($sorting) {
					case 'default':
						$query_args['orderby'] = array(
							'menu_order'	=> 'ASC',
							'date'			=> 'DESC',
							'ID'				=> 'DESC'
						);
					break;

					case 'rating':
         			$query_args['meta_query'][] = array(
         				'relation' => 'OR',
						   'key_reviews_average_value' => array(
						      'key' => 'lt_reviews_average',
						   ),
						   'key_reviews_average' => array(
						      'key' => 'lt_reviews_average',
						      'compare' => 'NOT EXISTS',
						   )
         			);

         			$query_args['orderby']  	= array(
         				'key_reviews_average_value' => 'DESC',
         				'key_reviews_average' => 'DESC',
         				'date' 			  => 'DESC'
         			);
         			$query_args['order']       = 'DESC';

					break;

					case 'date':
         			$query_args['orderby']		= 'date';
         			$query_args['order']			= 'DESC';
					break;

					case 'date-old': 
						$query_args['orderby']		= 'date';
         			$query_args['order']			= 'ASC';
					break;

					case 'featured':
						$query_args['meta_key']		= '_featured';
						$query_args['orderby']  	= array(
         				'meta_value' => 'DESC',
         				'date' 			  => 'DESC'
         			);
         			$query_args['order']			= 'DESC';
					break;

					case 'random':
         			$query_args['orderby']		= 'rand';
         			$query_args['order']			= 'DESC';
					break;

					default:
						$query_args['orderby'] = Array(
							'menu_order'	=> 'ASC',
							'date'			=> 'DESC',
							'ID'				=> 'DESC'
						);
					break;
				}
			}

		//}

		return $query_args;
	 }

	/* source 
	* https://wordpress.stackexchange.com/questions/61775/how-to-query-posts-based-on-lat-lng-coordinate-as-post-meta
	* https://ourcodeworld.com/articles/read/1019/how-to-find-nearest-locations-from-a-collection-of-coordinates-latitude-and-longitude-with-php-mysql
	*/
	public function get_nearby_locations( $lat, $lng, $min_distance = 0, $max_distance = 100, $limit = 99, $post_type = 'job_listing', $use_miles = false ) {
		global $wpdb;
		
		$meta_lat_key = '_lt_map_latitude';
		$meta_lng_key = '_lt_map_longitude';

		$miles_to_km = $use_miles ? 1 : 1.609344;
		
		$query = "SELECT DISTINCT
			lat.post_id,
			lt.post_title,
			lat.meta_value as latitude,
			lng.meta_value as longitude,
			((ACOS(SIN(%f * PI() / 180) * SIN(lat.meta_value * PI() / 180) + COS(%f * PI() / 180) * COS(lat.meta_value * PI() / 180) * COS((%f - lng.meta_value) * PI() / 180)) * 180 / PI()) * 60 * 1.1515 * {$miles_to_km}) AS distance
			FROM {$wpdb->postmeta} AS lat
			LEFT JOIN {$wpdb->postmeta} as lng ON lat.post_id = lng.post_id
			INNER JOIN {$wpdb->posts} as lt ON lt.ID = lat.post_id
			WHERE lat.meta_key = %s AND lng.meta_key = %s AND lt.post_type = %s
			HAVING distance > %d AND distance < %d ORDER BY distance ASC LIMIT %d;";
	

		$prepared_query = $wpdb->prepare( $query, [ $lat, $lat, $lng, $meta_lat_key, $meta_lng_key, $post_type, $min_distance, $max_distance, $limit ] );
			
		$wp_query = $wpdb->get_results( $prepared_query );
		$ids = [];
		if($wp_query && is_array($wp_query) && count($wp_query) > 0){
			foreach ($wp_query as $lt) {
				$ids[] = $lt->post_id;
			}
		}
		return $ids;
	}

	// Get Listing Map Ajax
	public function get_listings_map(){
      $results = array();
  
      $args = apply_filters( 'job_manager_get_listings_args', array() );

      $args['posts_per_page'] = -1;
      $jobs = get_job_listings( $args );

      if ( $jobs->have_posts() ) {
         while ( $jobs->have_posts() ) {
            $jobs->the_post();

            $post_id = get_the_ID();

            $logo = get_post_meta($post_id, '_lt_logo_image', true);
            $logo_attachment = wp_get_attachment_image_src($logo, 'thumbnail');
            $first_cat = Lestin_Lising_Theme::instance()->get_first_category($post_id); 
            $lt_logo = '';
            if( isset($logo_attachment[0]) && $logo_attachment[0] ){
               $lt_logo = '<img src="' . esc_url($logo_attachment[0]) . '"/>';
            }else{
               $lt_logo = isset($first_cat['icon_html']) ? $first_cat['icon_html'] : '';
            }

            $lat_long = get_post_meta($post_id,  '_lt_map', true);
            $lat = isset($lat_long['lat']) && $lat_long['lat'] ? $lat_long['lat'] : '';
            $lng = isset($lat_long['lng']) && $lat_long['lng'] ? $lat_long['lng'] : '';
            $status = Lestin_Lising_Theme::instance()->check_open($post_id);
            $location = get_post_meta($post_id, '_job_location', true);
            $phone = get_post_meta($post_id, '_lt_phone', true);
            $tagline = get_post_meta($post_id, '_lt_tagline', true);
            $featured = get_post_meta($post_id, '_featured', true);

            $url_thumbnail = get_the_post_thumbnail_url($post_id, 'post_thumbnail');

            $html = '<span class="gva-map-content-popup">';
               $html .= '<span class="lt-top">';
                  if($status['text']){
                     $html .= '<span class="listing-time ' . $status['check'] . '">' . $status['text'] . '</span>';
                  }
                  if($featured){
                     $html .= '<span class="listing-featured">' . esc_html__('Featured', 'lestin-themer') . '</span>';
                  }
               $html .= '</span>';

               $html .= '<span class="content-inner">';
                  $html .= '<h3 class="title"><a href="' . get_the_permalink() . '" rel="bookmark">' . get_the_title() . '</a></h3>';
                  if( !empty($tagline) ){
                     $html .= '<span class="listing-tagline">' . $tagline . '</span>';
                  }
                  if($location){
                     $html .= '<span class="location"><i class="fas fa-map-marker-alt"></i>' . $location . '</span>';
                  }
                  if($phone){
                     $html .= '<span class="phone"><i class="icon fas fa-phone-alt"></i><a href="tel:' . $phone . '">' . $phone . '</a></span>';
                  } 
               $html .= '</span>';

               $html .= '<span class="image" style="background-image:url(\'' . $url_thumbnail . '\')"></span>';
            $html .= '</span>';

            $results[] = array(
               'id'     => get_the_ID(),
               'title'  => get_the_title(),
               'lat'    => $lat,
               'lon'    => $lng,
               'icon'   => wp_kses_post($lt_logo),
               'html'   => $html
            );
            
         }
      }
      echo json_encode($results);
      exit;
   }
}

new Lestin_Filter();