<?php

if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly
}
class Lestin_Job_Listing{


   public static function getInstance() {
      if (!isset(self::$instance) && !(self::$instance instanceof Lestin_Job_Listing)) {
         self::$instance = new Lestin_Job_Listing();
      }
      return self::$instance;
   }

   public function __construct(){ 
      add_filter( 'register_post_type_job_listing', array( $this, 'override_content_type_label' ), 10 );
      add_filter( 'wp_insert_post_data', array($this, 'default_comments_on') );
   }

   public static function override_content_type_label($args) {
      $singular = 'Listing'; 
      $plural   = 'Listings';

      $args['label'] = $plural;

      $args['labels'] = array(
         'name'                  => $plural,
         'singular_name'         => $singular,
         'menu_name'             => __( 'Listings', 'lestin-themer' ),
         // translators: Placeholder %s is the plural label of the job listing post type.
         'all_items'             => sprintf( __( 'All %s', 'lestin-themer' ), $plural ),
         'add_new'               => __( 'Add New', 'lestin-themer' ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'add_new_item'          => sprintf( __( 'Add %s', 'lestin-themer' ), $singular ),
         'edit'                  => __( 'Edit', 'lestin-themer' ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'edit_item'             => sprintf( __( 'Edit %s', 'lestin-themer' ), $singular ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'new_item'              => sprintf( __( 'New %s', 'lestin-themer' ), $singular ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'view'                  => sprintf( __( 'View %s', 'lestin-themer' ), $singular ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'view_item'             => sprintf( __( 'View %s', 'lestin-themer' ), $singular ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'search_items'          => sprintf( __( 'Search %s', 'lestin-themer' ), $plural ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'not_found'             => sprintf( __( 'No %s found', 'lestin-themer' ), $plural ),
         // translators: Placeholder %s is the plural label of the job listing post type.
         'not_found_in_trash'    => sprintf( __( 'No %s found in trash', 'lestin-themer' ), $plural ),
         // translators: Placeholder %s is the singular label of the job listing post type.
         'parent'                => sprintf( __( 'Parent %s', 'lestin-themer' ), $singular ),
         'featured_image'        => __( 'Featured Image', 'lestin-themer' ),
         'set_featured_image'    => __( 'Set Featured Image', 'lestin-themer' ),
         'remove_featured_image' => __( 'Remove Featured Image', 'lestin-themer' ),
         'use_featured_image'    => __( 'Use as Featured Image', 'lestin-themer' )
      );
      $args['show_in_nav_menus'] = true;
      $args['show_in_rest']      = false;
      $args['supports']          = array( 'title', 'editor', 'custom-fields', 'publicize', 'thumbnail', 'author', 'excerpt', 'comments');
   
      return $args;
   }

   function default_comments_on( $data ) {
      if( $data['post_type'] == 'job_listing' ) {
         $data['comment_status'] = 'open';
      }
      return $data;
   }
}

new Lestin_Job_Listing();