<?php

if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly
}
class Lestin_Listings_Taxonomy_Amenities{


   public static function getInstance() {
      if (!isset(self::$instance) && !(self::$instance instanceof Lestin_Listings_Taxonomy_Amenities)) {
         self::$instance = new Lestin_Listings_Taxonomy_Amenities();
      }
      return self::$instance;
   }

   public function __construct(){ 
      add_action( 'init', array( $this, 'definition' ), 1 );
   }


   public static function definition() {
      $labels = array(
         'name'              => __( 'Amenities', 'lestin-themer' ),
         'singular_name'     => __( 'Amenity', 'lestin-themer' ),
         'search_items'      => __( 'Search Amenities', 'lestin-themer' ),
         'all_items'         => __( 'All Amenities', 'lestin-themer' ),
         'parent_item'       => __( 'Parent Amenity', 'lestin-themer' ),
         'parent_item_colon' => __( 'Parent Amenity:', 'lestin-themer' ),
         'edit_item'         => __( 'Edit', 'lestin-themer' ),
         'update_item'       => __( 'Update', 'lestin-themer' ),
         'add_new_item'      => __( 'Add New', 'lestin-themer' ),
         'new_item_name'     => __( 'New Amenity', 'lestin-themer' ),
         'menu_name'         => __( 'Amenities', 'lestin-themer' ),
      );

      register_taxonomy( 'job_listing_amenity', 'job_listing', array(
         'labels'            => apply_filters( 'lestin_taxomony_amenities_labels', $labels ),
         'hierarchical'      => true,
         'query_var'         => 'amenity',
         'rewrite'           => array( 'slug' =>  'amenity' ),
         'public'            => true,
         'show_ui'           => true,
         'show_in_rest'      => false,
         'menu_position'       => 10,
         'show_in_nav_menus'   => true,
         'publicly_queryable'  => true
      ) );
   }

}

new Lestin_Listings_Taxonomy_Amenities();