<?php

if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly
}
class Lestin_Listings_Taxonomy_Region{


   public static function getInstance() {
      if (!isset(self::$instance) && !(self::$instance instanceof Lestin_Listings_Taxonomy_Region)) {
         self::$instance = new Lestin_Listings_Taxonomy_Region();
      }
      return self::$instance;
   }

   public function __construct(){ 
      add_action( 'init', array( $this, 'definition' ), 1 );
   }


   public static function definition() {
      $labels = array(
         'name'              => __( 'Regions', 'lestin-themer' ),
         'singular_name'     => __( 'Region', 'lestin-themer' ),
         'search_items'      => __( 'Search Regions', 'lestin-themer' ),
         'all_items'         => __( 'All Regions', 'lestin-themer' ),
         'parent_item'       => __( 'Parent Region', 'lestin-themer' ),
         'parent_item_colon' => __( 'Parent Region:', 'lestin-themer' ),
         'edit_item'         => __( 'Edit', 'lestin-themer' ),
         'update_item'       => __( 'Update', 'lestin-themer' ),
         'add_new_item'      => __( 'Add New', 'lestin-themer' ),
         'new_item_name'     => __( 'New Region', 'lestin-themer' ),
         'menu_name'         => __( 'Regions', 'lestin-themer' ),
      );

      register_taxonomy( 'job_listing_region', 'job_listing', array(
         'labels'            => apply_filters( 'lestin_taxomony_regions_labels', $labels ),
         'hierarchical'      => true,
         'query_var'         => 'region',
         'rewrite'           => array( 'slug' => __( 'region', 'lestin-themer' ) ),
         'public'            => true,
         'show_ui'           => true,
         'show_in_rest'      => false,
         'show_in_menu'        => true,
         'menu_position'       => 5,
         'show_in_nav_menus'   => true,
         'publicly_queryable'  => true,
         'exclude_from_search' => false,
         'has_archive'         => true
      ) );
   }

}

new Lestin_Listings_Taxonomy_Region();