<?php

if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly
}
class Lestin_Listings_Taxonomy_Tags{


   public static function getInstance() {
      if (!isset(self::$instance) && !(self::$instance instanceof Lestin_Listings_Taxonomy_Tags)) {
         self::$instance = new Lestin_Listings_Taxonomy_Tags();
      }
      return self::$instance;
   }

   public function __construct(){ 
      add_action( 'init', array( $this, 'definition' ), 1 );
   }


   public static function definition() {
      $labels = array(
         'name'              => __( 'Tags', 'lestin-themer' ),
         'singular_name'     => __( 'Tag', 'lestin-themer' ),
         'search_items'      => __( 'Search Tags', 'lestin-themer' ),
         'all_items'         => __( 'All Tags', 'lestin-themer' ),
         'parent_item'       => __( 'Parent Tag', 'lestin-themer' ),
         'parent_item_colon' => __( 'Parent Tag:', 'lestin-themer' ),
         'edit_item'         => __( 'Edit', 'lestin-themer' ),
         'update_item'       => __( 'Update', 'lestin-themer' ),
         'add_new_item'      => __( 'Add New', 'lestin-themer' ),
         'new_item_name'     => __( 'New Tag', 'lestin-themer' ),
         'menu_name'         => __( 'Tags', 'lestin-themer' ),
      );

      register_taxonomy( 'job_listing_tag', 'job_listing', array(
         'labels'             => apply_filters( 'lestin_taxomony_tags_labels', $labels ),
         'hierarchical'       => true,
         'query_var'          => 'listing-tag',
         'rewrite'            => array( 'slug' => __( 'listing-tag', 'lestin-themer' ) ),
         'public'             => true,
         'show_ui'            => true,
         'show_in_rest'       => true
      ) );
   }

}

new Lestin_Listings_Taxonomy_Tags();