<?php
class Lestin_Package{
	
	private static $instance;
  	public static function getInstance() {
    	if (!isset(self::$instance) && !(self::$instance instanceof Lestin_Package)) {
      	self::$instance = new Lestin_Package();
    	}
    	return self::$instance;
  	}

  	public function __construct(){
	 	add_action('init', array($this, 'register_post_type_lt_package'));
  	}

	function register_post_type_lt_package(){
		$labels = array(
			'name' => __( 'LT Package', 'lestin-themer' ),
			'singular_name' => __( 'Package', 'lestin-themer' ),
			'add_new' => __( 'Add New Package', 'lestin-themer' ),
			'add_new_item' => __( 'Add New Package', 'lestin-themer' ),
			'edit_item' => __( 'Edit Package', 'lestin-themer' ),
			'new_item' => __( 'New Package', 'lestin-themer' ),
			'view_item' => __( 'View Package', 'lestin-themer' ),
			'search_items' => __( 'Search Packages', 'lestin-themer' ),
			'not_found' => __( 'No Packages found', 'lestin-themer' ),
			'not_found_in_trash' => __( 'No Packages found in Trash', 'lestin-themer' ),
			'parent_item_colon' => __( 'Parent Package:', 'lestin-themer' ),
			'menu_name' => __( 'Listing Packages', 'lestin-themer' ),
		);

		$args = array(
			'labels' => $labels,
			'hierarchical' => true,
			'description' => 'List Package',
			'supports' => array( 'title'),
			'public' => true,
			'show_ui' => true,
			'show_in_menu'		=> 'edit.php?post_type=job_listing',
			'menu_position' => 30,
			'show_in_nav_menus' => false,
			'publicly_queryable' => true,
			'exclude_from_search' => false,
			'has_archive' => true,
			'query_var' => true,
			'can_export' => true,
			'rewrite' => true,
			'capability_type' => 'post'
		);
		register_post_type( 'lt_package', $args );
	}
}

new Lestin_Package();