<?php
function lestin_register_meta_boxes(){
	$prefix = 'lestin_';
	global $meta_boxes;
	$meta_boxes = array();

	/* ====== Metabox Template ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'lestin'),
		'pages' => array( 'gva__template'),
		'priority'   => 'high',
		'fields' => array(
			array(
				'name' => esc_html__('Template Type', 'lestin'),
				'id'   => "gva_template_type",
				'type' => 'text'
			),
		)
	);

	/* ====== Metabox Page ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'lestin'),
		'pages' => array( 'page'),
		'priority'   => 'high',
		'fields' => array(
			array(
            'name' => esc_html__('Full Width', 'lestin'),
            'id'   => "{$prefix}page_full_width",
            'type' => 'switch',
            'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'lestin'),
            'std' => 0,
         ),
			array(
				'name' => esc_html__('Header Layout', 'lestin'),
				'id'   => "{$prefix}header_layout",
				'type' => 'select',
				'options' => lestin_list_header_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
			array(
				'name' => esc_html__('Footer Layout', 'lestin'),
				'id'   => "{$prefix}footer_layout",
				'type' => 'select',
				'options' => lestin_list_footer_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
			array(
				'name' => esc_html__('Extra page class', 'lestin'),
				'id' => $prefix . 'extra_page_class',
				'desc' => esc_html__("If you wish to add extra classes to the body class of the page (for custom css use), then please add the class(es) here.", 'lestin'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),
		)
	);

	/* ====== Metabox Page Title ====== */
	$meta_boxes[] = array(
		'id' => 'gavias_metaboxes_page_heading',
		'title' => esc_html__('Page Title & Breadcrumb', 'lestin'),
		'pages' => array( 'post', 'page', 'product', 'portfolio', 'tribe_events'),
		'context' => 'normal',
		'priority'   => 'high',
		'fields' => array(
		  	array(
				'name' => esc_html__('Remove Title of Page', 'lestin'),   
				'id'   => "{$prefix}disable_page_title",
				'type' => 'switch',
				'std'  => 0,
		  	),
		  	array(
			 	'name' => esc_html__('Disable Breadcrumbs', 'lestin'),
			 	'id'   => "{$prefix}no_breadcrumbs",
			 	'type' => 'switch',
			 	'desc' => esc_html__('Disable the breadcrumbs from under the page title on this page.', 'lestin'),
			 	'std' => 0,
		  	),
		  	array(
			 	'name' => esc_html__('Breadcrumb Layout', 'lestin'),
			 	'id'   => "{$prefix}breadcrumb_layout",
			 	'type' => 'select',
			 	'options' => array(
				 	'layout_options'    => esc_html__('Default Options in Layout Template', 'lestin'),
				 	'page_options'      => esc_html__('Individuals Options This Page', 'lestin')
			 	),
			 	'multiple' => false,
			 	'std'  => 'theme_options',
			 	'desc' => esc_html__('You can use breadcrumb settings default in Layout Template or individuals this page', 'lestin')
		  	),
		  	array(
			 	'name' 	=> esc_html__( 'Background Overlay Color', 'lestin' ),
			 	'id'   	=> "{$prefix}breacrumb_bg_color",
			 	'desc' 	=> esc_html__( "Set an overlay color for hero heading image.", 'lestin' ),
			 	'type' 	=> 'color',
			 	'class' => 'breadcrumb_setting',
			 	'std'  	=> '',
		  	),
		  	array(
			 	'name'       => esc_html__( 'Overlay Opacity', 'lestin' ),
			 	'id'         => "{$prefix}breacrumb_bg_opacity",
			 	'desc'       => esc_html__( 'Set the opacity level of the overlay. This will lighten or darken the image depening on the color selected.', 'lestin' ),
			 	'clone'      => false,
			 	'type'       => 'slider',
			 	'prefix'     => '',
			 	'class'   	  => 'breadcrumb_setting',
			 	'js_options' => array(
				  	'min'  => 0,
				  	'max'  => 100,
				  	'step' => 1,
			 	),
			 	'std'   => '50'
		  	),
		  	array(
			 	'name'  	=> esc_html__('Breadcrumb Background Image', 'lestin'),
			 	'id'    	=> "{$prefix}breacrumb_image",
			 	'type'  	=> 'image_advanced',
			 	'class'   	=> 'breadcrumb_setting',
			 	'max_file_uploads' => 1
		  	),
		)
	);

	$meta_boxes[] = array(
	 'id'    => 'metaboxes_lt_package',
	 'title' => esc_html__('Data', 'lestin'),
	 'pages' => array( 'lt_package' ),
	 'fields' => array(
		array (
		  'name'    => esc_html__('Package Type', 'lestin'),
		  'id'      => "lt_package_type",
		  'type'    => 'text',
		  'desc' 	=> esc_html__('Woocommerce product ID', 'lestin'),
		),
		array (
		  'name'   	=> esc_html__('Listing Limit', 'lestin'),
		  'id'    	=> "lt_package_limit",
		  'type'    => 'number',
		  'desc' 	=> esc_html__('How many listings should this package allow the user to post?', 'lestin'),
		),
		array (
		  'name'   	=> esc_html__('Listing Duration', 'lestin'),
		  'id'    	=> "lt_package_duration",
		  'type'    => 'number',
		  'desc' 	=> esc_html__('How many days should listings posted with this package be active?', 'lestin'),
		),
		array (
		  'name'   	=> esc_html__('Listing Count', 'lestin'),
		  'id'    	=> "lt_package_count",
		  'type'    => 'number',
		  'desc' 	=> esc_html__('How many listings has the user already posted with this package?', 'lestin'),
		),
		array (
		  'name'   	=> esc_html__('Feature Listings', 'lestin'),
		  'id'    	=> "lt_package_feature",
		  'type'    => 'checkbox',
		),
		array (
		  'name'   	=> esc_html__('User', 'lestin'),
		  'id'    	=> "lt_package_user",
		  'type'    => 'user',
		),
		array (
		  'name'   	=> esc_html__('Order ID', 'lestin'),
		  'id'    	=> "lt_package_order",
		  'type'    => 'textfield',
		  'desc' 	=> esc_html__('Optionally link this package to an order.', 'lestin'),
		),
	 )
  );

	/* ====== Metabox Listing ====== */
	$meta_boxes[] = array(
	 	'id'    => 'metaboxes_listings_images',
	 	'title' => esc_html__('Logo & Banner Image', 'lestin'),
	 	'post_types' => array( 'job_listing' ),
	 	'context'	=> 'side',
	 	'priority'	=> 'low',
	 	'fields' => array(
			array (
			  'name'   		=> esc_html__('Logo Image', 'lestin'),
			  'id'    		=> "_lt_logo_image",
			  'type'       => 'single_image',
			),
			array (
			  'name'   		=> esc_html__('Banner Image', 'lestin'),
			  'id'    		=> "_lt_banner_image",
			  'type'       => 'single_image',
			),
	 	)
  	);

	/* ====== Metabox Listing ====== */
	$meta_boxes[] = array(
	 	'id'    => 'metaboxes_listings_layout',
	 	'title' => esc_html__('Layout Demo', 'lestin'),
	 	'post_types' => array( 'job_listing' ),
	 	'context'	=> 'side',
	 	'priority'	=> 'low',
	 	'fields' => array(
			array(
				'name' => esc_html__('Layout Single Listing', 'lestin'),
				'id'   => "{$prefix}template_layout",
				'type' => 'select',
				'options' => lestin_get_single_listing_layout(),
				'multiple' => false,
				'std'  => '',
			),
	 	)
  	);
  	

  	/* Listing Page Box Page
	================================================== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_listings_page',
		'title' => esc_html__('Listings Page Options', 'lestin'),
		'pages' => array('page'),
		'priority'   => 'high',
		'fields' => array(

			// SIDEBAR CONFIG
			array(
				'name' => esc_html__('Layout Listings Page', 'lestin'),
				'id'   => "{$prefix}lt_layout_page",
				'type' => 'select',
				'options' => array(
				  ''                   	=> esc_html__('--Default--', 'lestin'),
				  'half_map'        	  	=> esc_html__('Half Map', 'lestin'),
				  'filters_left'       	=> esc_html__('Sidebar Filters Left', 'lestin'),
				  'filters_right'       => esc_html__('Sidebar Filters Right', 'lestin'),
				  'filters_hidden'		=> esc_html__('Hidden Filters', 'lestin')
				),
				'class'	=> 'setting-lt_layout_page',
				'multiple' => false,
			),

			array(
				'name' => esc_html__('Show Map Top Page', 'lestin'),
				'id'   => "{$prefix}lt_show_map_top",
				'type' => 'select',
				'options' => array(
				  ''                   	=> esc_html__('--Default--', 'lestin'),
				  'disable'             => esc_html__('Disable Map', 'lestin'),
				  'container'           => esc_html__('Container', 'lestin'),
				  'contain-fw'          => esc_html__('Full Width', 'lestin'),
				),
				'class'	=> 'setting-lt_show_map_top',
				'default'  => 'container',
				'multiple' => false,
			),

			array(
				'name' => esc_html__('Layout Item', 'lestin'),
				'id'   => "{$prefix}lt_layout_item",
				'type' => 'select',
				'options' => array(
				  ''                   	=> esc_html__('--Default--', 'lestin'),
				  'item-grid-1'        	=> esc_html__('Grid', 'lestin'),
				  'item-list'       		=> esc_html__('List', 'lestin'),
				),
				'multiple' => false,
			),

			array(
				'name' 		=> esc_html__('Per Page', 'lestin'),
				'id'   		=> "{$prefix}lt_per_page",
				'type' 		=> 'number',
				'std'			=> 12
			),
			
			array(
				'name' => esc_html__('Show Rating', 'lestin'),
				'id'   => "{$prefix}lt_show_rating",
				'type' => 'select',
				'options' => array(
				  	''      		=> esc_html__( 'Hidden', 'lestin' ),
					'star'  		=> esc_html__( 'Star', 'lestin' ),
					'number'  	=> esc_html__( 'Number', 'lestin' )
				),
				'std'	=> 'star'
			),

			array(
				'name' => esc_html__('Show Tagline', 'lestin'),
				'id'   => "{$prefix}lt_show_tagline",
				'type' => 'select',
				'options' => array(
				  	'yes'     	=> esc_html__( 'Yes', 'lestin' ),
					'no'  		=> esc_html__( 'no', 'lestin' )
				),
				'std'		=> 'yes'
			),
			
			array(
				'name' => esc_html__('Grid columns large screen', 'lestin'),
				'id'   => "{$prefix}lt_grid_columns_lg",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'lestin'),
				  '1'               	=> esc_html__('1 Column', 'lestin'),
				  '2'                => esc_html__('2 Columns', 'lestin'),
				  '3'        	  		=> esc_html__('3 Columns', 'lestin'),
				  '4'       			=> esc_html__('4 Columns', 'lestin'),
				  '5'       			=> esc_html__('5 Columns', 'lestin'),
				  '6'       			=> esc_html__('6 Columns', 'lestin'),
				),
				'std' => '2',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Grid columns medium screen', 'lestin'),
				'id'   => "{$prefix}lt_grid_columns_md",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'lestin'),
				  '1'               	=> esc_html__('1 Column', 'lestin'),
				  '2'                => esc_html__('2 Columns', 'lestin'),
				  '3'        	  		=> esc_html__('3 Columns', 'lestin'),
				  '4'       			=> esc_html__('4 Columns', 'lestin'),
				  '5'       			=> esc_html__('5 Columns', 'lestin'),
				  '6'       			=> esc_html__('6 Columns', 'lestin'),
				),
				'std' => '2',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Grid columns small screen', 'lestin'),
				'id'   => "{$prefix}lt_grid_columns_sm",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'lestin'),
				  '1'               	=> esc_html__('1 Column', 'lestin'),
				  '2'                => esc_html__('2 Columns', 'lestin'),
				  '3'        	  		=> esc_html__('3 Columns', 'lestin'),
				  '4'       			=> esc_html__('4 Columns', 'lestin'),
				  '5'       			=> esc_html__('5 Columns', 'lestin'),
				  '6'       			=> esc_html__('6 Columns', 'lestin'),
				),
				'std' => '2',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Grid columns extra small screen', 'lestin'),
				'id'   => "{$prefix}lt_grid_columns_xs",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'lestin'),
				  '1'               	=> esc_html__('1 Column', 'lestin'),
				  '2'                => esc_html__('2 Columns', 'lestin'),
				  '3'        	  		=> esc_html__('3 Columns', 'lestin'),
				  '4'       			=> esc_html__('4 Columns', 'lestin'),
				  '5'       			=> esc_html__('5 Columns', 'lestin'),
				  '6'       			=> esc_html__('6 Columns', 'lestin'),
				),
				'std' => '2',
				'class'   => 'grid_setting'
			),

			array(
				'name' => esc_html__('Pagination Style', 'lestin'), 
				'id'   => "{$prefix}lt_pagination_style",
				'type' => 'select',
				'options' => array(
					''                => esc_html__('--Default--', 'lestin'),
				  'load_more'        => esc_html__('Load More', 'lestin'),
				  'paginate'         => esc_html__('Paginate', 'lestin')
				),
				'std'	=> 'load_more',
				'multiple' => false
			),
		)
	);

	return $meta_boxes;
 }  
  /********************* META BOX REGISTERING ***********************/
  add_filter( 'rwmb_meta_boxes', 'lestin_register_meta_boxes' , 99 );

