<?php
$header_options = array();

if(class_exists('GVA_Layout_Model')){
	$headers = GVA_Layout_Model::getInstance()->get_templates('header_layout', 'title');
	foreach ($headers as $key => $item) {
		$header_options[$item['id']] = $item['title'];
	}
}

Redux::setSection( $opt_name, array(
	'title' => esc_html__('Listings General', 'lestin'),
	'desc' => '',
	'icon' => 'el-icon-wrench',
	'fields' => array(
		array(
			'id'        => 'lt_business_hours',
			'type'      => 'select',
			'title'     => esc_html__('Business Hours Group', 'lestin'),
			'options'   => array(
				'enable'         => esc_html__('Enable', 'lestin'),
				'disable'        => esc_html__('Disable', 'lestin'),
			),
			'default' => 'enable'
		),
		array(
			'id'        => 'lt_default_business_hours',
			'type'      => 'select',
			'title'     => esc_html__('Status Open/Close when unset Business Hours', 'lestin'),
			'desc'      => '',
			'options'   => array(
				'open_day'      => esc_html__('Open', 'lestin'),
				'close_day'     => esc_html__('Closed', 'lestin'),
				'hidden'        => esc_html__('Hidden Status', 'lestin')
			),
			'default' => 'open'
		),
		array(
		  	'id'  	=> 'lt-rating-options',
		  	'type'  	=> 'info',
		  	'raw' 	=> '<h3 style="margin: 0;">' . esc_html__( 'Listing Rating Option', 'lestin' ) . '</h3>'
		),
		array(
		  'id'            => 'lt_reviews',
		  'type'          => 'multi_text',
		  'title'         => esc_html__('Listing Review Item / Title[key]', 'lestin'),
		  'subtitle'      => esc_html__('Example: Quality[quality], Format: Title[key]', 'lestin'),
		  'default'       => array('Quality[quality]', 'Hospitality[hospitality]', 'Service[service]', 'Pricing[price]')
		),
		array(
			'id'        => 'lt_review_allow_owner',
			'type'      => 'select',
			'title'     => esc_html__('Allow listing owner review', 'lestin'),
			'desc'      => esc_html__('Allow listing owners to review their own listings.', 'lestin'),
			'options'   => array(
				'enable'         => esc_html__('Enable', 'lestin'),
				'disable'        => esc_html__('Disable', 'lestin'),
			),
			'default' => 'enable'
		),
		array(
			'id'        => 'lt_show_rating',
			'type'      => 'select',
			'title'     => esc_html__('Show Rating Default', 'lestin'),
			'options'   => array(
			  	''      		=> esc_html__( 'Hidden', 'lestin' ),
				'star'  		=> esc_html__( 'Star', 'lestin' ),
				'number'  	=> esc_html__( 'Number', 'lestin' )
			),
			'default' => 'star'
		),

		array(
		  	'id'  	=> 'lt-currency-options',
		  	'type'  	=> 'info',
		  	'raw' 	=> '<h3 style="margin: 0;">' . esc_html__( 'Listing Currency', 'lestin' ) . '</h3>'
		),
		array(
			'id'        => 'lt_currency_symbol',
			'type'      => 'text',
			'title'     => esc_html__('Currency Symbol', 'lestin'),
			'default' => '$'
		),
		array(
			'id'        => 'lt_enable_paid',
			'type'      => 'select',
			'title'     => esc_html__('Listing Package', 'lestin'),
			'options'   => array(
				'enable'         => esc_html__('Enable', 'lestin'),
				'disable'        => esc_html__('Disable', 'lestin'),
			),
			'default' => 'enable'
		),
		array(
		  	'id'  	=> 'lt-single-options',
		  	'type'  	=> 'info',
		  	'raw' 	=> '<h3 style="margin: 0;">' . esc_html__( 'Listing Single Page', 'lestin' ) . '</h3>'
		),
		array(
         'id'        => 'lt_single_contact_form',
         'type'      => 'text',
         'title'     => esc_html__('Contact Form ID', 'lestin'),
         'default' => '1415'
      ),
	)
));