<?php 
   $job_dashboard_page_id = get_option( 'job_manager_job_dashboard_page_id' );
   $dashboard_link = $job_dashboard_page_id ? get_the_permalink($job_dashboard_page_id) : '';
?>
<h3 class="page-title"><?php echo esc_html__('My Listings', 'lestin') ?></h3>
<?php set_query_var('paged', 2) ;?>
<div class="job-manager-jobs">
   <?php if ( ! $jobs ) : ?>
      <div class="alert alert-warning"><?php echo esc_html_e( 'You do not have any active listings.', 'lestin' ); ?></div>
   <?php else : ?>
      <?php foreach ( $jobs as $job ) : ?>
         <?php $attrs['job'] = $job; ?>
         <?php get_job_manager_template( 'loop/item-my-listing.php', $attrs) ?>
      <?php endforeach; ?>
   <?php endif; ?>

   <nav class="job-manager-pagination">
      <?php
         $current_page = isset($_GET['pagex']) && $_GET['pagex'] ? $_GET['pagex'] : 1;
         echo paginate_links( apply_filters( 'job_manager_pagination_args', [
            'base'      => add_query_arg( array('dashboard' => 'my-listings', 'pagex' => '%#%' ), $dashboard_link ),
            'format'    => '',
            'current'   => max( 1, $current_page ),
            'total'     => $max_num_pages,
            'prev_text' => '&larr;',
            'next_text' => '&rarr;',
            'type'      => 'list',
            'end_size'  => 3,
            'mid_size'  => 3
         ] ) );
      ?>
   </nav>
</div>

<div class="modal fade modal-ajax-user-form" id="popup-ajax-package" abindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="false" style="background-color: rgba(0, 0, 0, 0.5);">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header-form">
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <div class="ajax-package-form-content"></div>
         </div>
      </div>
   </div>
</div>
