<?php
if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly.
}

$thumbnail = 'post-thumbnail';
if(isset($thumb_size) && $thumb_size){
   $thumbnail = $thumb_size;
}
$post_id = get_the_ID();
$_rand = wp_rand();
$phone = get_post_meta($post_id, '_lt_phone', true);
$logo = lestin_image_attach($post_id, '_lt_logo_image', true, 'thumbnail');
$tagline = get_post_meta($post_id, '_lt_tagline', true);
$status = Lestin_Lising_Theme::instance()->check_open($post_id);
$price_from = get_post_meta($post_id, '_lt_price_from', true);
$price_to = get_post_meta($post_id, '_lt_price_to', true);
$review_avg = get_post_meta($post_id, 'lt_reviews_average', true); 
$featured = get_post_meta($post_id, '_featured', true);
$results_reviews = get_post_meta($post_id, 'lt_results_reviews', true); 
$count_comment = Lestin_Listing_Comment::instance()->total_reviews($post_id, false, true);
$suffix_review = sprintf(esc_html__('(%s)', 'lestin'), $count_comment);

$rterms =  wp_get_post_terms($post_id, 'job_listing_region');
$city = $country = false;
if ( !empty($rterms) ) {
   foreach ($rterms as $term) {
      if($term->parent == 0){
         $country = $term;
      }else{
         $city = $term;
      }
   }
}

$link_region_country = $link_region_city = '';
if( isset($regions['city']) && $regions['city'] ){
   $link_region_city = get_term_link($regions['city'], 'job_listing_region');
}
if(isset($regions['country']) && $regions['country']){
   $link_region_country = get_term_link($regions['country'], 'job_listing_region');
}

$images = get_post_meta( $post_id, '_lt_gallery_images', true );
$video = get_post_meta( $post_id, '_lt_video', true );
?>

<div <?php job_listing_class('listing-block listing-two__single'); ?>>
   <div class="listing-two__wrap">
      <div class="listing-two__image">
         <?php  
            if ( has_post_thumbnail() ) {
               the_post_thumbnail( $thumbnail, array( 'alt' => get_the_title() ) );
            } 
         
            if( isset($logo[0]) ){
               echo '<div class="listing-two__logo"><img src="' . esc_url($logo[0]) . '" alt="' . the_title_attribute(array('echo' => false)) . '"/></div>';
            } 

            echo '<div class="listing-one__labels">';
               if($status['text']){
                  echo '<div class="listing-one__label listing-one__time ' . esc_attr( $status['check'] ) . '">' . esc_html($status['text']) . '</div>';
               }
               if($featured){
                  echo '<div class="listing-one__label listing-one__featured"><span>' . esc_html__('Featured', 'lestin') . '</span></div>';
               } 
            echo '</div>';
         ?> 

         <a href="<?php the_permalink() ?>" class="listing-two__link-overlay" aria-label="link" ></a>
      </div>   

      <div class="listing-two__content">
         <div class="listing-two__meta-top">
            <div class="listing-two__category lt_block-category">
               <?php Lestin_Lising_Theme::instance()->html_categories($post_id, true); ?>
            </div>
            <?php 
               if( !empty($review_avg) ){ 
                  $review_avg = round( $review_avg, 1 );
                  echo Lestin_Listing_Comment::instance()->show_star_by_avg($review_avg, '', $suffix_review); 
               }
            ?>
         </div>
         <div class="listing-two__content-inner">
            <h3 class="listing-two__title"><a href="<?php the_permalink() ?>"><?php wpjm_the_job_title(); ?></a></h3>

            <?php if( !empty($tagline) && $show_tagline == 'yes' ){ ?>
               <div class="listing-two__tagline"><?php echo esc_html($tagline) ?></div>
            <?php } ?>  

            <div class="listing-two__meta">
               <?php 
                  if($city || $country){
                     echo '<div class="listing-two__location">';      
                        echo '<i class="icon fas fa-map-marker-alt"></i>';
                        echo '<span class="listing-two__regions">';
                           if($city){ 
                              echo '<a href="' . esc_url(get_term_link($city->term_id, 'job_listing_region')) . '">' . esc_html($city->name) . '</a>';
                           } 
                           if( $country ){
                              echo '<span>,&nbsp;</span><a href="' . esc_url(get_term_link($country->term_id, 'job_listing_region')) . '">' . esc_html($country->name) . '</a>';
                           } 
                        echo '</span>';
                     echo '</div>';
                  } 
                  if($phone){
                     echo '<div class="listing-two__phone hidden">';
                        echo '<a href="tel:' . esc_attr($phone) . '"><i class="icon fa-solid fa-square-phone-flip"></i>' . esc_html($phone) . '</a>';
                     echo '</div>';
                  } 
               ?>
            </div>    

            <div class="listing-two__footer">
               <div class="listing-two__footer-left">
                  <?php 
                     if($price_from){
                        echo '<div class="listing-two__price">';
                           echo '<span class="listing-two__price-label">' . esc_html__('From', 'lestin') . '</span>' . esc_html($price_from) . lestin_get_option('lt_currency_symbol', '$');
                        echo '</div>';
                     } 
                  ?>
               </div>
               <div class="listing-two__footer-right">
                  <?php
                     if($images && is_array($images) && count($images) > 0){
                        echo '<div class="listing-two__gallery">';
                              $i = 0;
                              foreach($images as $image){
                                 $i++;
                                 $classes = ($i>1) ? 'hidden' : 'listing-two__gallery-link';
                                 $image_src = wp_get_attachment_image_src($image, 'full');
                                 if( isset($image_src[0]) ){
                                    echo '<a class="' .esc_attr($classes) . '" href="' . esc_url($image_src[0]) . '" data-elementor-lightbox-slideshow="' . esc_attr($_rand) . '">';
                                       if($i == 1){
                                          echo '<i class="fa-solid fa-camera"></i>';
                                          echo '<span>' . count($images) . '</span>';
                                       }
                                    echo '</a>';
                                 }  
                              }
                        echo '</div>';
                     } 
                     
                     if($video){ 
                        echo '<a class="listing-two__video popup-video" href="' . esc_url($video) . '"><i class="fa-solid fa-video"></i></a>';
                     }

                     if(class_exists('Lestin_Addons_Wishlist_Ajax')){
                        Lestin_Addons_Wishlist_Ajax::instance()->html_icon($post_id);
                     }
                  ?>
               </div>  
            </div> 

         </div>
      </div> 

   </div>
</div>
   
