<?php
/* @var \Tangibledesign\Listivo\Widgets\General\HeroSearchV3Widget $lstCurrentWidget */
global $lstCurrentWidget;

$lstSearchFields = $lstCurrentWidget->getFields();
?>
<div class="listivo-hero-search-v3">
    <div class="listivo-hero-search-v3__content">
        <div class="listivo-hero-search-v3__heading-container">
            <div class="listivo-hero-search-v3__wave">
                <svg viewBox="0 0 65 35">
                    <g>
                        <g>
                            <path d="M1.9959,17.76303c3.45394,-1.31258 5.97725,-0.02794 8.00457,1.00492c1.99024,1.01423 3.20698,1.5532 5.0671,0.84662c1.85966,-0.70657 2.41196,-1.91785 3.22746,-3.99809c0.83096,-2.11972 1.86516,-4.75643 5.3191,-6.06902c3.45348,-1.31184 5.97679,-0.02645 8.00377,1.00567c1.99036,1.01498 3.20652,1.55357 5.06618,0.84737c1.85932,-0.70695 2.41116,-1.91747 3.22678,-3.99809c0.8305,-2.11861 1.86424,-4.75643 5.31773,-6.06827c3.45394,-1.31295 5.97679,-0.02682 8.00434,1.00641c1.98978,1.01386 3.20595,1.5532 5.06527,0.84662c0.93842,-0.35683 1.98853,0.11733 2.34558,1.05744c0.35694,0.93974 -0.11444,1.99085 -1.05274,2.34842c-3.45406,1.31258 -5.97691,0.02645 -8.004,-1.00716c-1.99013,-1.01386 -3.20641,-1.55208 -5.06561,-0.84588c-1.85898,0.70657 -2.41116,1.91785 -3.22609,3.99697c-0.83073,2.11935 -1.86459,4.75643 -5.31841,6.06939c-3.45394,1.31258 -5.97725,0.02645 -8.0048,-1.00641c-1.98978,-1.01423 -3.20595,-1.5532 -5.06527,-0.847c-1.85966,0.7062 -2.41196,1.91822 -3.22746,3.99846c-0.83096,2.11898 -1.86516,4.75681 -5.3191,6.06939c-3.45428,1.31258 -5.97759,0.02719 -8.00503,-1.00641c-1.99036,-1.01386 -3.20686,-1.55283 -5.06653,-0.84625c-0.93842,0.35683 -1.98864,-0.11696 -2.34558,-1.05707c-0.35694,-0.94049 0.11444,-1.99197 1.05274,-2.34805zM6.03544,28.40411c3.45394,-1.31221 5.97725,-0.02682 8.00468,1.00567c1.99024,1.01423 3.20686,1.5532 5.06699,0.84625c1.85966,-0.70657 2.41196,-1.9171 3.22769,-3.99771c0.83073,-2.11935 1.86504,-4.75643 5.31887,-6.06864c3.45348,-1.31258 5.97691,-0.02682 8.00377,1.00567c1.99036,1.01423 3.20652,1.5532 5.06618,0.84662c1.85932,-0.7062 2.41104,-1.91747 3.22689,-3.99734c0.83027,-2.11935 1.86413,-4.75643 5.31761,-6.06864c3.45394,-1.31258 5.97691,-0.02719 8.00434,1.00641c1.98978,1.01349 3.20595,1.55357 5.06527,0.847c0.93842,-0.35757 1.98864,0.11547 2.34558,1.05632c0.35694,0.94049 -0.11444,1.99234 -1.05274,2.34805c-3.45394,1.31295 -5.97702,0.02719 -8.00388,-1.00604c-1.99013,-1.01423 -3.20652,-1.55283 -5.06573,-0.84625c-1.85886,0.70546 -2.41116,1.91822 -3.22609,3.99734c-0.83073,2.11935 -1.86447,4.75643 -5.31841,6.06939c-3.45394,1.31221 -5.97736,0.02645 -8.00468,-1.00678c-1.98978,-1.01349 -3.20606,-1.55357 -5.06527,-0.84662c-1.85978,0.70695 -2.41196,1.91785 -3.22769,3.99883c-0.83073,2.11898 -1.86504,4.75643 -5.31898,6.06827c-3.45428,1.31295 -5.97771,0.02719 -8.00514,-1.00604c-1.99001,-1.01349 -3.20675,-1.55283 -5.06641,-0.84625c-0.93842,0.35645 -1.98864,-0.11621 -2.34558,-1.0567c-0.35694,-0.94049 0.11444,-1.99197 1.05274,-2.34879z"
                                  fill="#eeeeee" fill-opacity="1"></path>
                        </g>
                    </g>
                </svg>
            </div>

            <?php if (!empty($lstCurrentWidget->getHeading())) : ?>
                <h1 class="listivo-hero-search-v3__heading">
                    <?php echo nl2br($lstCurrentWidget->getHeading()); ?>

                    <div class="listivo-hero-search-v3__circle">
                        <svg viewBox="0 0 158 175">
                            <path d="M 69.29 1.20 C 71.15 0.24 74.45 2.57 72.24 4.24 C 70.23 6.46 65.98 3.33 69.29 1.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 1.20 C 88.15 0.24 91.45 2.57 89.24 4.24 C 87.23 6.46 82.98 3.33 86.29 1.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 54.26 2.40 L 54.84 2.19 C 57.36 4.58 54.03 4.96 52.10 4.91 C 52.08 2.91 52.68 3.10 54.26 2.40 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.16 2.19 C 104.74 2.91 106.05 2.73 105.90 4.91 C 103.97 4.96 100.64 4.58 103.16 2.19 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.29 15.21 C 37.45 13.81 40.23 18.04 37.65 18.66 C 35.31 19.93 32.38 17.04 35.29 15.21 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.28 15.21 C 54.45 13.81 57.23 18.04 54.65 18.66 C 52.31 19.93 49.38 17.04 52.28 15.21 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.29 15.20 C 71.15 14.23 74.45 16.57 72.24 18.24 C 70.23 20.46 65.98 17.33 69.29 15.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 15.20 C 88.15 14.24 91.45 16.57 89.24 18.24 C 87.23 20.46 82.98 17.33 86.29 15.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.32 15.26 C 105.84 14.26 108.57 16.88 105.71 18.80 C 102.57 19.29 101.32 18.04 103.32 15.26 Z"
                                  fill="#eeeeee"/>
                            <path d="M 120.32 15.26 C 122.84 14.26 125.57 16.88 122.71 18.80 C 119.57 19.28 118.32 18.04 120.32 15.26 Z"
                                  fill="#eeeeee"/>
                            <path d="M 18.28 29.22 C 22.14 28.37 20.73 30.14 20.87 32.87 C 19.62 32.98 18.36 32.98 17.10 32.85 C 17.07 31.29 16.81 30.19 18.28 29.22 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.29 29.21 C 37.45 27.81 40.23 32.04 37.65 32.66 C 35.31 33.93 32.38 31.04 35.29 29.21 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.28 29.20 C 54.46 27.82 57.22 32.03 54.65 32.66 C 52.31 33.93 49.39 31.04 52.28 29.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.29 29.20 C 71.15 28.23 74.45 30.57 72.24 32.24 C 70.23 34.46 65.98 31.33 69.29 29.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 29.20 C 88.15 28.23 91.45 30.57 89.24 32.24 C 87.23 34.46 82.98 31.33 86.29 29.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.32 29.26 C 105.84 28.26 108.57 30.88 105.71 32.80 C 102.57 33.28 101.32 32.04 103.32 29.26 Z"
                                  fill="#eeeeee"/>
                            <path d="M 120.32 29.26 C 122.84 28.26 125.57 30.88 122.71 32.80 C 119.57 33.29 118.32 32.04 120.32 29.26 Z"
                                  fill="#eeeeee"/>
                            <path d="M 137.15 29.10 C 139.39 28.85 141.15 29.29 140.93 31.95 C 141.61 33.64 138.01 32.73 137.13 32.87 C 137.02 31.62 137.02 30.36 137.15 29.10 Z"
                                  fill="#eeeeee"/>
                            <path d="M 18.26 43.20 C 22.20 41.91 21.34 45.86 19.88 47.87 C 17.11 47.17 15.78 45.44 18.26 43.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.29 43.22 C 37.65 41.91 39.80 45.57 37.81 46.81 C 35.74 49.25 31.97 45.35 35.29 43.22 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.28 43.20 C 54.97 42.52 55.04 43.72 55.77 45.84 C 55.01 46.61 54.17 47.32 53.22 47.86 C 51.77 45.97 49.71 45.35 52.28 43.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.28 43.20 C 71.97 42.53 72.04 43.71 72.77 45.84 C 72.01 46.62 71.18 47.32 70.22 47.85 C 68.77 45.96 66.71 45.35 69.28 43.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 43.24 C 88.43 42.67 89.05 43.21 90.12 44.99 C 89.46 46.04 88.65 46.98 87.78 47.86 C 85.27 46.17 84.64 46.16 86.29 43.24 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.29 43.24 C 105.43 42.67 106.05 43.21 107.12 44.99 C 106.46 46.04 105.65 46.98 104.78 47.86 C 102.27 46.17 101.64 46.16 103.29 43.24 Z"
                                  fill="#eeeeee"/>
                            <path d="M 120.28 43.24 C 122.98 41.96 125.50 45.56 123.04 47.06 C 120.36 48.80 118.25 45.56 120.28 43.24 Z"
                                  fill="#eeeeee"/>
                            <path d="M 137.13 43.11 C 139.00 42.97 140.48 42.93 140.99 45.07 C 141.19 47.25 139.64 47.12 138.12 47.86 C 136.84 46.35 136.90 44.98 137.13 43.11 Z"
                                  fill="#eeeeee"/>
                            <path d="M 2.26 44.25 C 5.10 43.00 4.13 47.58 2.19 47.91 C 0.78 46.02 0.48 46.03 2.26 44.25 Z"
                                  fill="#eeeeee"/>
                            <path d="M 154.10 44.10 C 156.55 44.00 158.04 45.98 155.82 47.82 C 153.89 47.53 154.04 45.62 154.10 44.10 Z"
                                  fill="#eeeeee"/>
                            <path d="M 3.68 60.64 C 2.88 62.63 1.50 61.00 0.00 60.82 L 0.00 57.59 C 2.56 56.78 4.79 57.60 3.68 60.64 Z"
                                  fill="#eeeeee"/>
                            <path d="M 18.35 57.29 C 21.50 55.68 21.91 63.25 18.64 61.36 C 16.42 60.91 16.55 58.22 18.35 57.29 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.35 57.30 C 36.15 56.12 38.11 58.72 38.86 59.22 C 38.01 60.26 37.25 62.54 35.64 61.35 C 33.41 61.00 33.56 58.18 35.35 57.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.28 57.20 C 54.97 56.53 55.04 57.71 55.77 59.84 C 55.01 60.62 54.18 61.32 53.22 61.86 C 51.77 59.96 49.71 59.35 52.28 57.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.28 57.20 C 71.97 56.53 72.04 57.71 72.77 59.84 C 72.01 60.61 71.17 61.32 70.22 61.86 C 68.77 59.97 66.71 59.35 69.28 57.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 57.24 C 88.43 56.66 89.06 57.22 90.12 58.99 C 89.46 60.04 88.65 60.98 87.78 61.86 C 85.27 60.17 84.64 60.16 86.29 57.24 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.29 57.24 C 105.43 56.67 106.05 57.21 107.12 58.99 C 106.46 60.04 105.65 60.98 104.78 61.86 C 102.27 60.17 101.64 60.16 103.29 57.24 Z"
                                  fill="#eeeeee"/>
                            <path d="M 121.36 57.31 C 123.42 55.99 125.56 60.93 122.36 61.35 C 120.75 62.54 119.99 60.27 119.14 59.22 C 119.84 58.52 120.58 57.88 121.36 57.31 Z"
                                  fill="#eeeeee"/>
                            <path d="M 138.35 57.29 C 140.37 55.98 142.58 60.84 139.36 61.36 C 137.14 63.09 136.00 57.99 138.35 57.29 Z"
                                  fill="#eeeeee"/>
                            <path d="M 158.00 58.05 L 158.00 61.23 C 156.24 61.29 154.57 62.36 154.03 59.93 C 153.87 57.16 155.93 56.53 158.00 58.05 Z"
                                  fill="#eeeeee"/>
                            <path d="M 3.99 73.08 C 4.11 75.82 2.05 76.51 0.00 74.92 L 0.00 71.61 C 1.97 71.36 3.26 70.56 3.99 73.08 Z"
                                  fill="#eeeeee"/>
                            <path d="M 18.35 71.29 C 21.49 69.68 21.92 77.25 18.64 75.36 C 16.42 74.91 16.55 72.22 18.35 71.29 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.35 71.30 C 36.15 70.12 38.11 72.72 38.86 73.22 C 38.01 74.26 37.25 76.54 35.64 75.35 C 33.41 75.00 33.56 72.17 35.35 71.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.35 71.30 C 53.15 70.12 55.11 72.72 55.86 73.22 C 55.01 74.27 54.25 76.54 52.64 75.35 C 50.41 74.99 50.56 72.18 52.35 71.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.28 71.20 C 71.97 70.53 72.04 71.71 72.77 73.84 C 72.01 74.62 71.18 75.32 70.22 75.86 C 68.77 73.97 66.71 73.35 69.28 71.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 71.24 C 88.43 70.67 89.05 71.21 90.12 72.99 C 89.46 74.04 88.65 74.98 87.78 75.86 C 85.26 74.18 84.64 74.15 86.29 71.24 Z"
                                  fill="#eeeeee"/>
                            <path d="M 104.36 71.31 C 106.43 69.99 108.56 74.93 105.36 75.35 C 103.75 76.54 102.99 74.27 102.14 73.22 C 102.84 72.52 103.58 71.88 104.36 71.31 Z"
                                  fill="#eeeeee"/>
                            <path d="M 121.36 71.31 C 123.42 69.99 125.56 74.92 122.36 75.35 C 120.76 76.54 119.98 74.27 119.14 73.22 C 119.84 72.52 120.58 71.88 121.36 71.31 Z"
                                  fill="#eeeeee"/>
                            <path d="M 138.35 71.29 C 140.38 69.98 142.58 74.84 139.36 75.36 C 137.14 77.09 136.00 71.99 138.35 71.29 Z"
                                  fill="#eeeeee"/>
                            <path d="M 158.00 72.09 L 158.00 75.40 C 156.03 75.64 154.73 76.43 154.01 73.92 C 153.89 71.18 155.96 70.48 158.00 72.09 Z"
                                  fill="#eeeeee"/>
                            <path d="M 3.99 87.08 C 4.11 89.82 2.05 90.51 0.00 88.92 L 0.00 85.60 C 1.97 85.36 3.27 84.57 3.99 87.08 Z"
                                  fill="#eeeeee"/>
                            <path d="M 18.35 85.29 C 20.04 83.96 22.21 88.07 20.24 89.24 C 18.00 91.85 15.35 86.54 18.35 85.29 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.35 85.30 C 36.15 84.11 38.06 86.65 38.77 87.20 C 38.62 88.44 36.94 89.46 36.00 90.14 C 33.81 89.16 33.08 86.65 35.35 85.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.35 85.30 C 53.15 84.11 55.06 86.64 55.75 87.20 C 55.70 88.41 53.89 89.48 53.00 90.14 C 50.81 89.16 50.08 86.65 52.35 85.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 70.19 85.26 C 73.09 86.51 73.50 87.69 70.81 89.72 C 67.86 88.54 67.55 87.29 70.19 85.26 Z"
                                  fill="#eeeeee"/>
                            <path d="M 87.19 85.27 C 90.14 86.50 90.44 87.71 87.80 89.76 C 84.87 88.40 84.51 87.38 87.19 85.27 Z"
                                  fill="#eeeeee"/>
                            <path d="M 104.34 85.30 C 106.07 83.99 108.20 88.06 106.24 89.24 C 104.73 91.17 103.50 88.80 102.26 87.80 C 102.21 86.78 103.66 85.91 104.34 85.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 121.34 85.30 C 123.07 83.99 125.20 88.06 123.24 89.24 C 121.73 91.17 120.50 88.79 119.25 87.80 C 119.23 86.77 120.65 85.91 121.34 85.30 Z"
                                  fill="#eeeeee"/>
                            <path d="M 138.35 85.29 C 140.04 83.96 142.21 88.07 140.24 89.24 C 138.00 91.85 135.35 86.54 138.35 85.29 Z"
                                  fill="#eeeeee"/>
                            <path d="M 158.00 86.08 L 158.00 89.40 C 156.03 89.64 154.73 90.43 154.01 87.92 C 153.89 85.18 155.95 84.49 158.00 86.08 Z"
                                  fill="#eeeeee"/>
                            <path d="M 3.99 101.08 C 4.10 103.82 2.05 104.52 0.00 102.92 L 0.00 99.60 C 1.97 99.36 3.27 98.57 3.99 101.08 Z"
                                  fill="#eeeeee"/>
                            <path d="M 19.27 99.37 C 22.05 99.05 21.07 105.18 18.35 103.71 C 16.12 102.27 16.71 99.90 19.27 99.37 Z"
                                  fill="#eeeeee"/>
                            <path d="M 36.25 99.41 C 37.13 98.71 38.39 101.17 38.86 101.78 C 37.55 102.69 36.27 105.18 34.76 103.24 C 33.19 101.60 34.08 99.80 36.25 99.41 Z"
                                  fill="#eeeeee"/>
                            <path d="M 53.25 99.41 C 54.13 98.71 55.39 101.17 55.86 101.78 C 54.55 102.69 53.27 105.18 51.76 103.24 C 50.19 101.60 51.08 99.80 53.25 99.41 Z"
                                  fill="#eeeeee"/>
                            <path d="M 70.22 99.14 C 71.26 99.99 73.54 100.75 72.35 102.36 C 71.70 105.07 68.72 104.12 67.88 102.01 C 68.54 100.96 69.35 100.02 70.22 99.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 87.26 99.46 C 88.32 98.89 91.55 102.43 88.72 103.80 C 85.52 104.90 83.95 100.70 87.26 99.46 Z"
                                  fill="#eeeeee"/>
                            <path d="M 104.16 99.23 C 106.46 99.72 108.11 101.04 106.24 103.24 C 104.73 105.18 103.45 102.69 102.14 101.78 C 102.68 100.83 103.39 99.99 104.16 99.23 Z"
                                  fill="#eeeeee"/>
                            <path d="M 121.16 99.23 C 123.47 99.72 125.11 101.04 123.24 103.24 C 121.73 105.18 120.45 102.69 119.14 101.78 C 119.68 100.83 120.39 99.99 121.16 99.23 Z"
                                  fill="#eeeeee"/>
                            <path d="M 138.12 99.14 C 141.50 99.91 142.15 102.36 139.00 104.16 C 136.55 102.76 136.44 101.31 138.12 99.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 158.00 100.08 L 158.00 103.39 C 156.03 103.64 154.74 104.44 154.01 101.92 C 153.90 99.17 155.95 98.49 158.00 100.08 Z"
                                  fill="#eeeeee"/>
                            <path d="M 3.97 115.07 C 4.13 117.83 2.06 118.47 0.00 116.95 L 0.00 113.77 C 1.76 113.71 3.42 112.64 3.97 115.07 Z"
                                  fill="#eeeeee"/>
                            <path d="M 19.27 113.37 C 22.05 113.05 21.07 119.18 18.35 117.71 C 16.12 116.27 16.70 113.91 19.27 113.37 Z"
                                  fill="#eeeeee"/>
                            <path d="M 36.25 113.41 C 37.13 112.71 38.39 115.17 38.86 115.78 C 37.54 116.70 36.27 119.18 34.76 117.24 C 33.19 115.60 34.08 113.80 36.25 113.41 Z"
                                  fill="#eeeeee"/>
                            <path d="M 53.22 113.14 C 54.27 113.99 56.54 114.75 55.35 116.36 C 54.70 119.07 51.72 118.12 50.88 116.01 C 51.54 114.96 52.35 114.02 53.22 113.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 70.22 113.14 C 71.27 113.99 73.54 114.75 72.35 116.36 C 71.70 119.07 68.72 118.12 67.88 116.01 C 68.54 114.96 69.35 114.02 70.22 113.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 87.26 113.46 C 88.34 112.91 91.54 116.42 88.72 117.80 C 85.52 118.89 83.95 114.69 87.26 113.46 Z"
                                  fill="#eeeeee"/>
                            <path d="M 104.26 113.46 C 105.32 112.89 108.55 116.43 105.72 117.80 C 102.52 118.89 100.95 114.70 104.26 113.46 Z"
                                  fill="#eeeeee"/>
                            <path d="M 121.16 113.23 C 123.46 113.72 125.11 115.04 123.24 117.24 C 121.73 119.18 120.45 116.69 119.14 115.78 C 119.68 114.83 120.39 113.99 121.16 113.23 Z"
                                  fill="#eeeeee"/>
                            <path d="M 138.12 113.14 C 141.50 113.91 142.16 116.35 139.00 118.16 C 136.54 116.76 136.44 115.32 138.12 113.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 158.00 114.18 L 158.00 117.41 C 155.44 118.22 153.21 117.40 154.32 114.36 C 155.12 112.37 156.50 114.00 158.00 114.18 Z"
                                  fill="#eeeeee"/>
                            <path d="M 2.19 127.06 C 4.17 128.11 3.95 128.81 3.90 130.90 C 1.30 130.96 0.09 129.01 2.19 127.06 Z"
                                  fill="#eeeeee"/>
                            <path d="M 19.27 127.37 C 21.06 126.49 22.27 133.46 19.07 131.91 C 16.27 131.42 16.25 127.84 19.27 127.37 Z"
                                  fill="#eeeeee"/>
                            <path d="M 36.24 127.43 C 39.32 127.38 39.35 132.25 36.07 131.98 C 33.35 131.37 33.16 127.81 36.24 127.43 Z"
                                  fill="#eeeeee"/>
                            <path d="M 53.22 127.14 C 54.27 127.99 56.54 128.75 55.35 130.36 C 54.70 133.07 51.72 132.12 50.88 130.01 C 51.54 128.96 52.35 128.02 53.22 127.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 70.22 127.14 C 71.27 127.99 73.54 128.76 72.35 130.36 C 71.70 133.07 68.72 132.12 67.88 130.01 C 68.54 128.96 69.35 128.02 70.22 127.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 87.26 127.46 C 88.34 126.91 91.54 130.42 88.72 131.80 C 85.53 132.90 83.95 128.69 87.26 127.46 Z"
                                  fill="#eeeeee"/>
                            <path d="M 104.26 127.46 C 105.33 126.90 108.55 130.43 105.72 131.80 C 102.53 132.90 100.95 128.69 104.26 127.46 Z"
                                  fill="#eeeeee"/>
                            <path d="M 121.20 127.27 C 124.05 127.72 125.13 129.77 122.71 131.78 C 119.37 132.91 118.17 128.75 121.20 127.27 Z"
                                  fill="#eeeeee"/>
                            <path d="M 138.12 127.14 C 139.64 127.89 141.19 127.75 140.99 129.93 C 140.47 132.08 139.00 132.03 137.13 131.89 C 136.90 130.02 136.84 128.65 138.12 127.14 Z"
                                  fill="#eeeeee"/>
                            <path d="M 155.19 127.28 C 158.17 127.72 156.96 131.28 154.10 130.90 C 154.09 129.43 153.85 128.25 155.19 127.28 Z"
                                  fill="#eeeeee"/>
                            <path d="M 17.10 142.15 C 18.36 142.02 19.62 142.02 20.87 142.13 C 20.73 143.01 21.64 146.61 19.95 145.93 C 17.29 146.14 16.85 144.40 17.10 142.15 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.29 142.20 C 36.81 141.68 37.67 142.26 38.86 143.12 C 38.11 144.64 38.25 146.21 36.07 145.97 C 33.91 145.20 33.21 143.80 35.29 142.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.29 142.20 C 53.81 141.68 54.67 142.26 55.86 143.12 C 55.11 144.64 55.25 146.21 53.07 145.97 C 50.91 145.20 50.21 143.80 52.29 142.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.29 142.20 C 71.15 141.24 74.45 143.57 72.24 145.24 C 70.23 147.46 65.98 144.33 69.29 142.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 142.20 C 88.15 141.23 91.45 143.57 89.24 145.24 C 87.23 147.46 82.98 144.33 86.29 142.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.35 142.34 C 105.05 141.02 108.48 143.69 106.24 145.24 C 104.17 147.96 100.52 143.10 103.35 142.34 Z"
                                  fill="#eeeeee"/>
                            <path d="M 120.35 142.34 C 122.05 141.02 125.48 143.69 123.24 145.24 C 121.16 147.96 117.52 143.10 120.35 142.34 Z"
                                  fill="#eeeeee"/>
                            <path d="M 137.13 142.13 C 138.38 142.02 139.64 142.02 140.90 142.15 C 141.15 144.39 140.71 146.15 138.05 145.93 C 136.36 146.61 137.27 143.01 137.13 142.13 Z"
                                  fill="#eeeeee"/>
                            <path d="M 35.29 156.20 C 36.81 155.67 37.67 156.26 38.86 157.12 C 38.11 158.64 38.25 160.21 36.07 159.97 C 33.91 159.20 33.21 157.80 35.29 156.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.29 156.20 C 53.81 155.68 54.67 156.26 55.86 157.12 C 55.11 158.64 55.25 160.21 53.07 159.97 C 50.91 159.21 50.21 157.80 52.29 156.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.29 156.20 C 71.15 155.23 74.45 157.57 72.24 159.24 C 70.23 161.46 65.98 158.33 69.29 156.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 156.20 C 88.15 155.24 91.45 157.57 89.24 159.24 C 87.23 161.46 82.98 158.33 86.29 156.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.35 156.34 C 105.04 155.02 108.48 157.69 106.24 159.24 C 104.16 161.97 100.52 157.09 103.35 156.34 Z"
                                  fill="#eeeeee"/>
                            <path d="M 120.35 156.34 C 122.04 155.02 125.49 157.69 123.24 159.24 C 121.16 161.97 117.52 157.09 120.35 156.34 Z"
                                  fill="#eeeeee"/>
                            <path d="M 52.10 170.09 C 53.74 169.94 54.61 170.21 55.94 171.14 C 55.29 173.99 51.77 172.25 52.10 170.09 Z"
                                  fill="#eeeeee"/>
                            <path d="M 69.29 170.20 C 71.15 169.23 74.45 171.57 72.24 173.24 C 70.23 175.46 65.98 172.33 69.29 170.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 86.29 170.20 C 88.15 169.23 91.45 171.57 89.24 173.24 C 87.23 175.46 82.98 172.33 86.29 170.20 Z"
                                  fill="#eeeeee"/>
                            <path d="M 103.34 170.39 C 104.12 170.08 104.97 169.98 105.90 170.09 C 106.04 172.27 104.74 172.09 103.16 172.81 C 102.38 171.38 101.25 171.30 103.34 170.39 Z"
                                  fill="#eeeeee"/>
                        </svg>
                    </div>
                </h1>
            <?php endif; ?>
        </div>

        <div class="listivo-hero-search-v3__search-form">
            <div class="listivo-app">
                <lst-search-form
                        base-url="<?php echo esc_url(get_post_type_archive_link(tdf_model_post_type())); ?>"
                        request-url="<?php echo esc_url(get_rest_url() . 'listivo/v1/listings'); ?>"
                        :dependency-terms="<?php echo htmlspecialchars(json_encode(tdf_app('dependency_terms'))); ?>"
                        :initial-term-count="<?php echo htmlspecialchars(json_encode($lstCurrentWidget->getTermCount())); ?>"
                        field-selector=".listivo-search-form-field"
                >
                    <div
                            slot-scope="props"
                            class="listivo-search listivo-search--v2 listivo-search--<?php echo esc_attr($lstCurrentWidget->getAlignModifier()); ?>"
                    >
                        <div class="listivo-search__search-icon">
                            <svg viewBox="0 0 60 60">
                                <g>
                                    <g>
                                        <path d="M27.02709,-0.01058c14.92046,0 27.05887,12.13766 27.05887,27.06288c0,5.2872 -1.52561,10.22391 -4.15821,14.39855l8.27991,8.27962c2.34867,2.34842 2.34867,6.15655 0,8.50422c-2.34821,2.34767 -6.15532,2.34767 -8.50365,0l-8.27991,-8.27925c-4.17229,2.63075 -9.1095,4.1575 -14.39701,4.1575c-14.92035,0 -27.0591,-12.13952 -27.0591,-27.06065c0,-14.92522 12.13829,-27.06288 27.0591,-27.06288zM27.02709,48.10018c11.60477,0 21.04591,-9.44322 21.04591,-21.04787c0,-11.60615 -9.44115,-21.04862 -21.04591,-21.04862c-11.60477,0 -21.04591,9.44247 -21.04591,21.04862c0,11.60466 9.44069,21.04787 21.04591,21.04787z"
                                              fill="#ffe9c6" fill-opacity="1"></path>
                                    </g>
                                </g>
                            </svg>
                        </div>

                        <?php if (!empty($lstCurrentWidget->getSearchFormLabel())) : ?>
                            <h3 class="listivo-search__heading">
                                <?php echo esc_html($lstCurrentWidget->getSearchFormLabel()); ?>

                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 117 6"
                                     width="117.0pt" height="6.0pt">
                                    <path d="M 50.00 1.17 C 61.34 0.90 72.67 1.06 84.00 0.45 C 94.56 0.41 105.35 -0.61 115.72 0.63 L 115.67 2.00 C 106.41 1.93 97.23 2.05 88.00 2.85 C 69.99 3.10 52.02 3.97 34.00 4.02 C 22.99 4.28 12.01 5.08 1.00 5.15 L 0.92 3.04 C 9.00 3.23 16.94 1.74 25.00 1.98 C 33.35 2.05 41.65 1.21 50.00 1.17 Z"
                                          fill="#ffa820"/>
                                </svg>
                            </h3>
                        <?php endif; ?>

                        <div class="listivo-search__inner">
                            <div class="listivo-search__fields">
                                <?php
                                global $lstSearchField;
                                foreach ($lstSearchFields as $lstSearchField) :
                                    if ($lstSearchField->displayAtStart(tdf_collect())) :
                                        get_template_part('templates/widgets/general/search/fields/' . $lstSearchField->getType());
                                    else :?>
                                        <template>
                                            <?php get_template_part('templates/widgets/general/search/fields/' . $lstSearchField->getType()); ?>
                                        </template>
                                    <?php
                                    endif;
                                endforeach;
                                ?>
                            </div>

                            <div class="listivo-search__search-button">
                                <button
                                        class="listivo-primary-button"
                                        :class="{'listivo-primary-button--loading': props.inProgress}"
                                        @click.prevent="props.onSearch"
                                        :disabled="props.inProgress"
                                >
                                    <span class="listivo-primary-button__text">
                                        <?php echo esc_html($lstCurrentWidget->getButtonLabel()); ?>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </lst-search-form>
            </div>
        </div>
    </div>

    <div class="listivo-hero-search-v3__mask-left">
        <svg viewBox="0 0 909 810">
            <g>
                <g>
                    <path
                            d="M906.05139,557.90154c9.14829,-68.98357 -5.46467,-110.9579 -24.92741,-133.37124c-29.50562,-33.97927 -79.63165,-37.48234 -109.03816,-47.68391c-84.07299,-29.16696 -120.04486,-171.10202 -161.97372,-220.79913c-111.1607,-131.75435 -346.5097,-208.42607 -489.02653,-114.19801c-150.3915,99.43369 -147.04205,355.91912 -62.35542,510.72672c151.24489,276.4766 609.08855,326.4553 771.40938,165.56787c48.41309,-47.98524 69.70024,-113.40316 75.91187,-160.24231z"
                            fill="#fffaf2"
                            fill-opacity="1"
                    ></path>
                </g>
            </g>
        </svg>
    </div>

    <div class="listivo-hero-search-v3__mask-inner">
        <svg viewBox="0 0 1984 1613">
            <g>
                <g>
                    <path
                            d="M0.99996,671.00101c5.98995,146.60434 51.50425,228.49509 99.99996,267.99846c73.52028,59.8875 178.79265,48.99835 243.50006,59.53216c184.99741,30.11639 311.01334,311.90292 415.99995,399.93644c278.33691,233.39344 794.4072,307.36512 1056.00002,59.99067c276.0466,-261.04222 176.25149,-792.58812 -55.49995,-1083.45806c-413.89389,-519.47566 -1381.94675,-457.37122 -1660.50007,-64.35936c-83.07999,117.21836 -103.5672,260.81613 -99.49997,360.3597z"
                            fill="#ff9c00"
                            fill-opacity="1"
                    ></path>
                </g>
            </g>
        </svg>
    </div>

    <div class="listivo-hero-search-v3__mask-outer">
        <svg viewBox="0 0 1984 1613">
            <g>
                <g>
                    <path
                            d="M0.99998,671.00044c5.98995,146.60508 51.50414,228.49584 99.99996,267.99883c73.52016,59.8875 178.79265,48.99835 243.50006,59.53216c184.99741,30.11713 311.01334,311.90292 415.99995,399.93681c278.33691,233.39344 794.4072,307.36438 1056.00002,59.99104c276.0466,-261.04222 176.25149,-792.58924 -55.50007,-1083.45843c-413.89378,-519.47566 -1381.94664,-457.37122 -1660.49995,-64.35899c-83.07999,117.21762 -103.5672,260.81538 -99.49997,360.35858z"
                            fill="#fffaf2"
                            fill-opacity="1"
                    ></path>
                </g>
            </g>
        </svg>
    </div>
</div>
