<?php
/* @var \Tangibledesign\Framework\Widgets\General\ServicesWidget $lstCurrentWidget */
global $lstCurrentWidget;
?>
<div class="listivo-services">
    <?php foreach ($lstCurrentWidget->getServices() as $lstIndex => $lstService) : ?>
        <div class="listivo-service-wrapper">
            <div
                <?php if (!empty($lstService['enable_border'])) : ?>
                    class="listivo-service elementor-repeater-item-<?php echo esc_attr($lstService['_id']); ?>"
                <?php else : ?>
                    class="listivo-service listivo-service--no-border elementor-repeater-item-<?php echo esc_attr($lstService['_id']); ?>"
                <?php endif; ?>
            >
                <?php if ($lstService['image']) : ?>
                    <div class="listivo-service__image">
                        <img
                                class="lazyload"
                                data-src="<?php echo esc_url($lstService['image']->getImageUrl('full')); ?>"
                                alt="<?php echo esc_attr($lstService['title']); ?>"
                        >
                    </div>
                <?php endif; ?>

                <div class="listivo-service__content">
                    <h4 class="listivo-service__title">
                        <?php echo esc_html($lstService['title']); ?>
                    </h4>

                    <p class="listivo-service__text">
                        <?php echo wp_kses_post($lstService['text']); ?>
                    </p>
                </div>

                <?php if (empty($lstIndex)) : ?>
                    <div class="listivo-service__arrow">
                        <svg
                                xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink"
                                viewBox="0, 0, 400,133.33333333333334"
                        >
                            <g>
                                <path
                                        d="M48.854 2.738 C 46.557 4.193,45.502 6.716,46.509 8.346 C 49.169 12.649,63.636 9.140,63.636 4.192 C 63.636 -0.492,55.256 -1.317,48.854 2.738 M72.727 4.545 C 72.727 7.374,75.589 9.091,80.303 9.091 C 85.017 9.091,87.879 7.374,87.879 4.545 C 87.879 1.717,85.017 0.000,80.303 0.000 C 75.589 0.000,72.727 1.717,72.727 4.545 M96.970 7.222 C 96.970 11.945,111.380 15.772,113.888 11.715 C 116.670 7.213,112.084 3.030,104.367 3.030 C 100.089 3.030,96.970 4.798,96.970 7.222 M26.515 8.149 C 19.617 9.952,19.617 18.196,26.515 18.135 C 34.211 18.068,40.502 13.335,38.088 9.430 C 35.924 5.929,35.284 5.858,26.515 8.149 M122.553 12.404 C 119.581 17.213,128.926 25.419,134.806 23.163 C 140.465 20.991,138.681 16.605,130.318 12.129 C 126.374 10.018,123.975 10.103,122.553 12.404 M3.636 21.818 C -0.388 25.843,-1.289 33.388,2.273 33.237 C 6.380 33.063,15.152 25.162,15.152 21.636 C 15.152 17.101,8.244 17.211,3.636 21.818 M143.760 27.564 C 140.712 32.495,150.152 40.565,156.238 38.230 C 161.106 36.362,161.091 35.861,156.003 30.240 C 149.856 23.447,146.727 22.763,143.760 27.564 M162.372 45.050 C 159.999 48.888,171.744 58.541,175.764 56.057 C 178.148 54.583,177.605 52.200,173.970 48.184 C 168.286 41.903,164.884 40.984,162.372 45.050 M180.114 63.942 C 178.980 65.777,180.892 70.118,184.363 73.588 C 190.091 79.317,190.855 79.425,192.645 74.759 C 195.994 66.032,184.796 56.366,180.114 63.942 M373.485 73.230 C 358.772 76.525,354.160 86.787,368.636 84.020 C 377.869 82.255,390.909 93.791,390.909 103.725 C 390.909 107.075,392.536 109.054,394.697 108.333 C 396.780 107.639,398.371 104.798,398.232 102.020 C 398.093 99.242,397.753 90.833,397.475 83.333 C 396.915 68.232,396.529 68.070,373.485 73.230 M198.556 81.703 C 195.448 86.731,206.220 98.022,210.265 93.977 C 212.426 91.817,211.432 88.873,207.068 84.509 C 202.631 80.072,200.083 79.232,198.556 81.703 M363.530 98.613 C 358.007 105.268,364.429 111.690,371.084 106.167 C 373.654 104.034,375.758 100.410,375.758 98.114 C 375.758 92.508,368.345 92.811,363.530 98.613 M217.104 101.469 C 214.804 107.462,226.556 114.050,231.223 109.383 C 233.602 107.004,232.878 104.839,228.625 101.623 C 221.115 95.943,219.234 95.918,217.104 101.469 M343.182 111.098 C 338.829 112.854,337.998 121.212,342.176 121.212 C 348.393 121.212,354.545 117.283,354.545 113.312 C 354.545 109.079,350.257 108.243,343.182 111.098 M239.875 116.982 C 241.246 124.169,254.545 126.821,254.545 119.908 C 254.545 117.292,253.293 115.152,251.763 115.152 C 250.233 115.152,246.685 114.271,243.880 113.194 C 240.036 111.719,239.049 112.652,239.875 116.982 M318.939 120.189 C 314.586 121.945,313.755 130.303,317.934 130.303 C 324.151 130.303,330.303 126.374,330.303 122.403 C 330.303 118.170,326.015 117.334,318.939 120.189 M263.636 125.404 C 263.636 127.710,266.645 130.383,270.322 131.345 C 278.344 133.442,280.135 132.125,277.742 125.888 C 275.513 120.080,263.636 119.672,263.636 125.404 M287.879 128.788 C 287.879 131.818,290.909 133.333,296.970 133.333 C 303.030 133.333,306.061 131.818,306.061 128.788 C 306.061 125.758,303.030 124.242,296.970 124.242 C 290.909 124.242,287.879 125.758,287.879 128.788 "
                                        stroke="none"
                                        fill="#000000"
                                        fill-rule="evenodd"
                                ></path>
                            </g>
                        </svg>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>
